/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.utils;

import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.utils.LevelUpRewardsUtil;
import com.azuredoom.levelingcore.utils.StatsUtils;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class LevelUpListenerRegistrar {
    private static final Set<UUID> REGISTERED = Collections.newSetFromMap(new ConcurrentHashMap());

    public static void ensureRegistered(Player player, PlayerRef playerRef, Config<GUIConfig> config) {
        UUID id = playerRef.getUuid();
        if (!REGISTERED.add(id)) {
            return;
        }
        World world = player.getWorld();
        EntityStore worldStore = world.getEntityStore();
        int levelupSound = SoundEvent.getAssetMap().getIndex((Object)((GUIConfig)config.get()).getLevelUpSound());
        LevelingCoreApi.getLevelServiceIfPresent().ifPresent(levelService -> {
            if (!((GUIConfig)config.get()).isEnableStatLeveling()) {
                return;
            }
            player.getWorld().execute(() -> levelService.registerLevelUpListener((playerId, newLevel) -> {
                if (!playerId.equals(id)) {
                    return;
                }
                StatsUtils.applyAllStats(player, playerRef, newLevel, config);
                world.execute(() -> {
                    TransformComponent transform = (TransformComponent)worldStore.getStore().getComponent(player.getReference(), EntityModule.get().getTransformComponentType());
                    SoundUtil.playSoundEvent3dToPlayer((Ref)player.getReference(), (int)levelupSound, (SoundCategory)SoundCategory.UI, (Vector3d)transform.getPosition(), (ComponentAccessor)worldStore.getStore());
                });
                if (((GUIConfig)config.get()).isEnableLevelUpRewardsConfig()) {
                    LevelUpRewardsUtil.giveRewards(newLevel, player);
                }
            }));
        });
    }

    public static void clear(UUID playerId) {
        REGISTERED.remove(playerId);
    }
}

