/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.systems;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.compat.MultipleHudCompat;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.hud.XPBarHud;
import com.azuredoom.levelingcore.level.LevelServiceImpl;
import com.hypixel.hytale.common.plugin.PluginIdentifier;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.plugin.PluginManager;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class XPTickSystem
extends EntityTickingSystem<EntityStore> {
    private final Config<GUIConfig> config;

    public XPTickSystem(Config<GUIConfig> config) {
        this.config = config;
    }

    public void tick(float var1, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)holder.getComponent(PlayerRef.getComponentType());
        if (player == null || playerRef == null) {
            return;
        }
        player.getWorld().execute(() -> LevelingCoreApi.getLevelServiceIfPresent().ifPresent(levelService1 -> {
            XPBarHud xpHud = new XPBarHud(playerRef, (LevelServiceImpl)levelService1, this.config);
            if (PluginManager.get().getPlugin(new PluginIdentifier("Buuz135", "MultipleHUD")) != null) {
                MultipleHudCompat.showHud(player, playerRef, xpHud);
            } else {
                player.sendMessage(Message.raw((String)"LevelingCore Error: MultipleHUD not found, XP HUD will not work correctly with other mods adding custom UI"));
                LevelingCore.LOGGER.at(Level.WARNING).log("MultipleHUD not found, XP HUD will not work correctly with other mods adding custom UI");
                player.getHudManager().setCustomHud(playerRef, (CustomUIHud)xpHud);
            }
        }));
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return Query.any();
    }
}

