/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.systems;

import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.lang.CommandLang;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.damage.Damage;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathSystems;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import java.util.UUID;
import javax.annotation.Nonnull;

public class LossXPEventSystem
extends DeathSystems.OnDeathSystem {
    private final Config<GUIConfig> config;

    public LossXPEventSystem(Config<GUIConfig> config) {
        this.config = config;
    }

    public Query<EntityStore> getQuery() {
        return Query.any();
    }

    public void onComponentAdded(@Nonnull Ref<EntityStore> ref, @Nonnull DeathComponent component, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        Damage deathInfo = component.getDeathInfo();
        if (deathInfo == null) {
            return;
        }
        if (!((GUIConfig)this.config.get()).isEnableXPLossOnDeath()) {
            return;
        }
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        player.getWorld().execute(() -> LevelingCoreApi.getLevelServiceIfPresent().ifPresent(levelService -> {
            UUID playerUuid = player.getUuid();
            long currentXp = levelService.getXp(playerUuid);
            int currentLevel = levelService.getLevel(playerUuid);
            if (((GUIConfig)this.config.get()).isEnableLevelDownOnDeath()) {
                long xpLoss = (long)((double)currentXp * ((GUIConfig)this.config.get()).getXpLossPercentage());
                if (xpLoss <= 0L) {
                    return;
                }
                levelService.removeXp(playerUuid, xpLoss);
                player.sendMessage(CommandLang.XP_LOST.param("xp", xpLoss));
                int levelAfter = levelService.getLevel(playerUuid);
                if (levelAfter < currentLevel) {
                    player.sendMessage(CommandLang.LEVEL_DOWN.param("level", levelAfter));
                }
            } else if (((GUIConfig)this.config.get()).isEnableAllLevelsLostOnDeath()) {
                levelService.setLevel(playerUuid, 1);
                player.sendMessage(CommandLang.DEATH_ALL_LEVELS);
            } else if (((GUIConfig)this.config.get()).getMinLevelForLevelDown() <= currentLevel) {
                long xpLoss;
                long levelFloorXp = levelService.getXpForLevel(currentLevel);
                long newXp = Math.max(levelFloorXp, currentXp - (xpLoss = (long)((double)currentXp * ((GUIConfig)this.config.get()).getXpLossPercentage())));
                long actualLoss = currentXp - newXp;
                if (actualLoss <= 0L) {
                    player.sendMessage(CommandLang.MIN_LEVEL_DEATH.param("level", currentLevel));
                    return;
                }
                levelService.setXp(playerUuid, newXp);
                player.sendMessage(CommandLang.XP_LOST.param("xp", actualLoss));
            }
        }));
    }
}

