/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.systems;

import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.utils.LevelUpListenerRegistrar;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class LevelUpTickingSystem
extends EntityTickingSystem<EntityStore> {
    private final Config<GUIConfig> config;

    public LevelUpTickingSystem(Config<GUIConfig> config) {
        this.config = config;
    }

    public void tick(float var1, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)holder.getComponent(PlayerRef.getComponentType());
        if (player == null || playerRef == null) {
            return;
        }
        LevelUpListenerRegistrar.ensureRegistered(player, playerRef, this.config);
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return Query.any();
    }
}

