/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.systems;

import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.utils.LevelUpRewardsUtil;
import com.azuredoom.levelingcore.utils.StatsUtils;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class LevelDownTickingSystem
extends EntityTickingSystem<EntityStore> {
    private final Config<GUIConfig> config;

    public LevelDownTickingSystem(Config<GUIConfig> config) {
        this.config = config;
    }

    public void tick(float var1, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
        Player player = (Player)holder.getComponent(Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)holder.getComponent(PlayerRef.getComponentType());
        if (player == null || playerRef == null) {
            return;
        }
        World world = player.getWorld();
        EntityStore world_store = world.getEntityStore();
        int leveldown_sound = SoundEvent.getAssetMap().getIndex((Object)((GUIConfig)this.config.get()).getLevelDownSound());
        LevelingCoreApi.getLevelServiceIfPresent().ifPresent(levelService1 -> {
            if (((GUIConfig)this.config.get()).isEnableStatLeveling()) {
                player.getWorld().execute(() -> levelService1.registerLevelDownListener((playerId, newLevel) -> {
                    StatsUtils.resetStats(player, playerRef);
                    StatsUtils.applyAllStats(player, playerRef, newLevel, this.config);
                    world.execute(() -> {
                        TransformComponent transform = (TransformComponent)world_store.getStore().getComponent(player.getReference(), EntityModule.get().getTransformComponentType());
                        SoundUtil.playSoundEvent3dToPlayer((Ref)player.getReference(), (int)leveldown_sound, (SoundCategory)SoundCategory.UI, (Vector3d)transform.getPosition(), (ComponentAccessor)world_store.getStore());
                    });
                    LevelUpRewardsUtil.clear(player.getUuid());
                }));
            }
        });
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return Query.any();
    }
}

