/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.systems;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.compat.SimplePartyCompat;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.lang.CommandLang;
import com.azuredoom.levelingcore.level.xp.XPValues;
import com.azuredoom.levelingcore.utils.NotificationsUtil;
import com.hypixel.hytale.common.plugin.PluginIdentifier;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.damage.Damage;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathSystems;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatValue;
import com.hypixel.hytale.server.core.modules.entitystats.asset.EntityStatType;
import com.hypixel.hytale.server.core.plugin.PluginManager;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import com.hypixel.hytale.server.npc.entities.NPCEntity;
import java.util.Map;
import javax.annotation.Nonnull;

public class GainXPEventSystem
extends DeathSystems.OnDeathSystem {
    private final Config<GUIConfig> config;

    public GainXPEventSystem(Config<GUIConfig> config) {
        this.config = config;
    }

    public Query<EntityStore> getQuery() {
        return Query.any();
    }

    public void onComponentAdded(@Nonnull Ref<EntityStore> ref, @Nonnull DeathComponent component, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        Damage.EntitySource entitySource;
        Ref attackerRef;
        Damage deathInfo = component.getDeathInfo();
        if (deathInfo == null) {
            return;
        }
        if (!((GUIConfig)this.config.get()).isEnableDefaultXPGainSystem()) {
            return;
        }
        if (store.getComponent(ref, PlayerRef.getComponentType()) != null) {
            return;
        }
        Damage.Source source = deathInfo.getSource();
        if (source instanceof Damage.EntitySource && (attackerRef = (entitySource = (Damage.EntitySource)source).getRef()).isValid()) {
            Player player = (Player)store.getComponent(attackerRef, Player.getComponentType());
            if (player == null) {
                return;
            }
            PlayerRef playerRef = Universe.get().getPlayer(player.getUuid());
            EntityStatMap statMap = (EntityStatMap)store.getComponent(ref, EntityStatMap.getComponentType());
            if (statMap == null) {
                return;
            }
            NPCEntity entity = (NPCEntity)store.getComponent(ref, NPCEntity.getComponentType());
            if (entity == null) {
                return;
            }
            Map<String, Integer> xpMap = XPValues.loadOrCreate(LevelingCore.configPath);
            int healthIndex = EntityStatType.getAssetMap().getIndex((Object)"Health");
            EntityStatValue healthStat = statMap.get(healthIndex);
            if (healthStat == null) {
                return;
            }
            float maxHealth = healthStat.getMax();
            long xpAmountHealth = Math.max(1L, (long)((double)maxHealth * ((GUIConfig)this.config.get()).getDefaultXPGainPercentage()));
            Integer getXPMapping = xpMap.getOrDefault(entity.getNPCTypeId(), Math.toIntExact(xpAmountHealth));
            long xpAmount = ((GUIConfig)this.config.get()).isUseConfigXPMappingsInsteadOfHealthDefaults() ? (long)getXPMapping.intValue() : xpAmountHealth;
            player.getWorld().execute(() -> LevelingCoreApi.getLevelServiceIfPresent().ifPresent(levelService -> {
                int levelBefore = levelService.getLevel(player.getUuid());
                if (PluginManager.get().getPlugin(new PluginIdentifier("net.justmadlime", "SimpleParty")) != null) {
                    SimplePartyCompat.onXPGain(xpAmount, player.getUuid(), levelService, this.config, playerRef);
                } else {
                    NotificationsUtil.sendNotification(playerRef, "Gained " + xpAmount + " XP");
                    levelService.addXp(player.getUuid(), xpAmount);
                }
                int levelAfter = levelService.getLevel(player.getUuid());
                if (levelAfter > levelBefore && ((GUIConfig)this.config.get()).isEnableLevelChatMsgs()) {
                    player.sendMessage(CommandLang.LEVEL_UP.param("level", levelAfter));
                }
            }));
        }
    }
}

