/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.logging;

import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class LogConfig {
    public static Logger setup(Class<?> clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord r) {
                return String.format("[%1$tF %1$tT] %2$s: %3$s%n", new Date(r.getMillis()), r.getLevel(), "LevelingCore: " + this.formatMessage(r));
            }
        });
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        return logger;
    }
}

