/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.xp;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.config.internal.ConfigManager;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class XPValues {
    public static final String FILE_NAME = "xpmapping.csv";
    public static final String RESOURCE_DEFAULT = "/defaultxpmapping.csv";

    private XPValues() {
    }

    public static Map<String, Integer> loadOrCreate(Path dataDir) {
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            Path configPath = dataDir.resolve(FILE_NAME);
            if (Files.notExists(configPath, new LinkOption[0])) {
                try (InputStream in = ConfigManager.class.getResourceAsStream(RESOURCE_DEFAULT);){
                    if (in == null) {
                        throw new LevelingCoreException("defaultxpmapping.csv not found in resources (expected at /defaultxpmapping.csv)");
                    }
                    LevelingCore.LOGGER.at(Level.INFO).log("Creating default XP config at " + String.valueOf(configPath));
                    Files.copy(in, configPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            Map<String, Integer> mapping = XPValues.readXpCsv(configPath);
            LevelingCore.LOGGER.at(Level.INFO).log("Loaded XP mapping from " + String.valueOf(configPath) + " " + mapping.size() + " entries)");
            return mapping;
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to load XP config", e);
        }
    }

    private static Map<String, Integer> readXpCsv(Path csvPath) throws Exception {
        LinkedHashMap<String, Integer> out = new LinkedHashMap<String, Integer>();
        try (BufferedReader reader = Files.newBufferedReader(csvPath, StandardCharsets.UTF_8);){
            String line;
            boolean firstNonEmptyLine = true;
            while ((line = reader.readLine()) != null) {
                int xp;
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (firstNonEmptyLine) {
                    firstNonEmptyLine = false;
                    if (line.equalsIgnoreCase("npctypeid,xp")) continue;
                }
                if ((parts = line.split(",", 2)).length != 2) {
                    LevelingCore.LOGGER.at(Level.WARNING).log("Skipping invalid CSV line: " + line);
                    continue;
                }
                String npcTypeId = parts[0].trim();
                String xpStr = parts[1].trim();
                if (npcTypeId.isEmpty()) {
                    LevelingCore.LOGGER.at(Level.WARNING).log("Skipping CSV line with empty npcTypeId: {0}", (Object)line);
                    continue;
                }
                try {
                    xp = Integer.parseInt(xpStr);
                }
                catch (NumberFormatException nfe) {
                    LevelingCore.LOGGER.at(Level.WARNING).log("Invalid XP value for " + npcTypeId + ": " + xpStr + " (line: " + line + ")");
                    continue;
                }
                out.put(npcTypeId, xp);
            }
        }
        return out;
    }
}

