/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.formulas.loader;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.TableLevelFormula;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;

public final class LevelTableLoader {
    private static final String DEFAULT_CSV = "# level,xp (XP floor required for that level)\n# Level 1 must be 0 XP\nlevel,xp\n1,0\n2,100\n3,250\n4,450\n5,700\n6,1000\n";

    private LevelTableLoader() {
    }

    public static TableLevelFormula loadOrCreateFromDataDir(String fileName) {
        try {
            Path path = LevelingCore.configPath;
            Files.createDirectories(path, new FileAttribute[0]);
            Path csvPath = path.resolve(fileName);
            if (Files.notExists(csvPath, new LinkOption[0])) {
                Files.writeString(csvPath, (CharSequence)DEFAULT_CSV, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
            }
            TreeMap<Integer, Long> map = new TreeMap<Integer, Long>();
            for (String raw : Files.readAllLines(csvPath, StandardCharsets.UTF_8)) {
                String line = raw.trim();
                if (line.isEmpty() || line.startsWith("#") || line.toLowerCase().startsWith("level")) continue;
                String[] parts = line.split(",", 2);
                if (parts.length != 2) {
                    throw new LevelingCoreException("Invalid CSV line (expected level,xp): " + raw);
                }
                int level = Integer.parseInt(parts[0].trim());
                long xp = Long.parseLong(parts[1].trim());
                if (level < 1) {
                    throw new LevelingCoreException("Level must be >= 1: " + raw);
                }
                if (xp < 0L) {
                    throw new LevelingCoreException("XP must be >= 0: " + raw);
                }
                if (map.put(level, xp) == null) continue;
                throw new LevelingCoreException("Duplicate level in CSV: " + level);
            }
            if (map.isEmpty()) {
                throw new LevelingCoreException("levels.csv is empty");
            }
            if (!map.containsKey(1)) {
                throw new LevelingCoreException("levels.csv must include level 1");
            }
            if ((Long)map.get(1) != 0L) {
                throw new LevelingCoreException("Level 1 must require 0 XP");
            }
            int maxLevel = map.keySet().stream().max(Integer::compareTo).orElse(1);
            for (int i = 1; i <= maxLevel; ++i) {
                if (map.containsKey(i)) continue;
                throw new LevelingCoreException("Missing level " + i + " in levels.csv (levels must be contiguous)");
            }
            long[] xpByLevel = new long[maxLevel + 1];
            for (int i = 1; i <= maxLevel; ++i) {
                xpByLevel[i] = (Long)map.get(i);
            }
            return new TableLevelFormula(xpByLevel);
        }
        catch (LevelingCoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to load levels.csv", e);
        }
    }
}

