/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.formulas;

import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import java.util.Arrays;

public class TableLevelFormula
implements LevelFormula {
    private final long[] xpByLevel;

    public TableLevelFormula(long[] xpByLevel) {
        if (xpByLevel == null || xpByLevel.length < 2) {
            throw new IllegalArgumentException("xpByLevel must include at least levels 0..1");
        }
        this.xpByLevel = xpByLevel;
        this.validate();
    }

    private void validate() {
        if (this.xpByLevel[1] != 0L) {
            throw new IllegalArgumentException("Level 1 must require 0 XP");
        }
        long prev = this.xpByLevel[1];
        for (int level = 2; level < this.xpByLevel.length; ++level) {
            long xp = this.xpByLevel[level];
            if (xp < prev) {
                throw new IllegalArgumentException("XP must be non-decreasing (level " + level + ")");
            }
            prev = xp;
        }
    }

    @Override
    public long getXpForLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("level must be >= 1");
        }
        if (level >= this.xpByLevel.length) {
            return this.xpByLevel[this.xpByLevel.length - 1];
        }
        return this.xpByLevel[level];
    }

    @Override
    public int getLevelForXp(long xp) {
        if (xp < 0L) {
            throw new IllegalArgumentException("xp must be >= 0");
        }
        int idx = Arrays.binarySearch(this.xpByLevel, xp);
        if (idx >= 0) {
            return Math.max(1, idx);
        }
        int insertionPoint = -(idx + 1);
        int level = insertionPoint - 1;
        return Math.max(1, Math.min(level, this.xpByLevel.length - 1));
    }
}

