/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.formulas;

import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;

public class LinearLevelFormula
implements LevelFormula {
    private final long xpPerLevel;
    private final int maxLevel;

    public LinearLevelFormula(long xpPerLevel, int maxLevel) {
        if (xpPerLevel <= 0L) {
            throw new IllegalArgumentException("xpPerLevel must be > 0");
        }
        if (maxLevel < 1) {
            throw new LevelingCoreException("maxLevel must be >= 1");
        }
        this.xpPerLevel = xpPerLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public long getXpForLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("level must be >= 1");
        }
        if (level == 1) {
            return 0L;
        }
        long value = this.xpPerLevel * (long)(level - 1);
        if (value < 0L || value >= Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return value;
    }

    @Override
    public int getLevelForXp(long xp) {
        if (xp < 0L) {
            throw new IllegalArgumentException("xp must be >= 0");
        }
        long level = xp / this.xpPerLevel + 1L;
        if (level >= (long)this.maxLevel) {
            return this.maxLevel;
        }
        return (int)level;
    }
}

