/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.formulas;

import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;

public class ExponentialLevelFormula
implements LevelFormula {
    private final double baseXp;
    private final double exponent;
    private final int maxLevel;

    public ExponentialLevelFormula(double baseXp, double exponent, int maxLevel) {
        if (baseXp <= 0.0) {
            throw new IllegalArgumentException("baseXp must be > 0");
        }
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("exponent must be > 0");
        }
        if (maxLevel < 1) {
            throw new LevelingCoreException("maxLevel must be >= 1");
        }
        this.baseXp = baseXp;
        this.exponent = exponent;
        this.maxLevel = maxLevel;
    }

    @Override
    public long getXpForLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("level must be >= 1");
        }
        if (level == 1) {
            return 0L;
        }
        double value = this.baseXp * Math.pow(level - 1, this.exponent);
        if (!Double.isFinite(value) || value >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        return (long)Math.ceil(value);
    }

    @Override
    public int getLevelForXp(long xp) {
        if (xp < 0L) {
            throw new IllegalArgumentException("xp must be >= 0");
        }
        double estimate = Math.pow((double)xp / this.baseXp, 1.0 / this.exponent);
        int level = !Double.isFinite(estimate) || estimate >= (double)this.maxLevel ? this.maxLevel : (estimate < 1.0 ? 1 : (int)Math.floor(estimate));
        while (this.getXpForLevel(level + 1) <= xp) {
            ++level;
        }
        while (level > 1 && this.getXpForLevel(level) > xp) {
            --level;
        }
        return Math.max(level, 1);
    }
}

