/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level.formulas;

import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class CustomExpressionLevelFormula
implements LevelFormula {
    private final String expressionText;
    private final Map<String, Double> constants;
    private final int maxLevel;

    public CustomExpressionLevelFormula(String xpForLevelExpression, Map<String, Double> constants, int maxLevel) {
        if (xpForLevelExpression == null || xpForLevelExpression.isBlank()) {
            throw new LevelingCoreException("custom.xpForLevel must not be blank");
        }
        if (maxLevel < 1) {
            throw new LevelingCoreException("maxLevel must be >= 1");
        }
        this.expressionText = xpForLevelExpression.trim();
        this.constants = constants == null ? Map.of() : Map.copyOf(constants);
        this.maxLevel = maxLevel;
    }

    @Override
    public long getXpForLevel(int level) {
        if (level < 1) {
            throw new LevelingCoreException("level must be >= 1");
        }
        double value = this.eval(level);
        if (!Double.isFinite(value) || value >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        if (value <= 0.0) {
            return 0L;
        }
        return (long)Math.ceil(value);
    }

    @Override
    public int getLevelForXp(long xp) {
        if (xp < 0L) {
            throw new IllegalArgumentException("xp must be >= 0");
        }
        if (this.getXpForLevel(1) > xp) {
            return 1;
        }
        if (this.getXpForLevel(this.maxLevel) <= xp) {
            return this.maxLevel;
        }
        int lo = 1;
        int hi = this.maxLevel;
        while (lo < hi) {
            int mid = lo + (hi - lo + 1) / 2;
            long midXp = this.getXpForLevel(mid);
            if (midXp <= xp) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    private double eval(int level) {
        ExpressionBuilder builder = new ExpressionBuilder(this.expressionText).variable("level");
        for (String k : this.constants.keySet()) {
            builder.variable(k);
        }
        Expression exp = builder.build();
        exp.setVariable("level", level);
        for (Map.Entry<String, Double> e : this.constants.entrySet()) {
            exp.setVariable(e.getKey(), e.getValue());
        }
        return exp.evaluate();
    }
}

