/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.level;

import com.azuredoom.levelingcore.database.JdbcLevelRepository;
import com.azuredoom.levelingcore.events.LevelDownListener;
import com.azuredoom.levelingcore.events.LevelUpListener;
import com.azuredoom.levelingcore.events.XpGainListener;
import com.azuredoom.levelingcore.events.XpLossListener;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import com.azuredoom.levelingcore.playerdata.PlayerLevelData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class LevelServiceImpl {
    private final LevelFormula formula;
    private final JdbcLevelRepository repository;
    private final Map<UUID, PlayerLevelData> cache = new ConcurrentHashMap<UUID, PlayerLevelData>();
    private final List<LevelDownListener> levelDownListeners = new ArrayList<LevelDownListener>();
    private final List<LevelUpListener> levelUpListeners = new ArrayList<LevelUpListener>();
    private final List<XpGainListener> xpGainListeners = new ArrayList<XpGainListener>();
    private final List<XpLossListener> xpLossListeners = new ArrayList<XpLossListener>();

    public LevelServiceImpl(LevelFormula formula, JdbcLevelRepository repository) {
        this.formula = formula;
        this.repository = repository;
    }

    private PlayerLevelData get(UUID id) {
        return this.cache.computeIfAbsent(id, uuid -> {
            PlayerLevelData stored = this.repository.load((UUID)uuid);
            return stored != null ? stored : new PlayerLevelData((UUID)uuid);
        });
    }

    public long getXp(UUID id) {
        return this.get(id).getXp();
    }

    public int getLevel(UUID id) {
        return this.formula.getLevelForXp(this.get(id).getXp());
    }

    public void addLevel(UUID id, int level) {
        if (level == 0) {
            return;
        }
        PlayerLevelData data = this.get(id);
        int oldLevel = this.getLevel(id);
        int targetLevel = oldLevel + level;
        if (targetLevel < 1) {
            targetLevel = 1;
        }
        long targetXp = this.formula.getXpForLevel(targetLevel);
        this.setDataXP(data, targetXp);
        int newLevel = this.getLevel(id);
        if (newLevel > oldLevel) {
            this.levelUpListeners.forEach(l -> l.onLevelUp(id, newLevel));
        } else if (newLevel < oldLevel) {
            this.levelDownListeners.forEach(l -> l.onLevelDown(id, newLevel));
        }
    }

    public void removeLevel(UUID id, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("level must be greater than 0");
        }
        PlayerLevelData data = this.get(id);
        int oldLevel = this.getLevel(id);
        int targetLevel = oldLevel - level;
        if (targetLevel < 1) {
            targetLevel = 1;
        }
        long targetXp = this.formula.getXpForLevel(targetLevel);
        this.setDataXP(data, targetXp);
        int newLevel = this.getLevel(id);
        if (newLevel < oldLevel) {
            this.levelDownListeners.forEach(l -> l.onLevelDown(id, newLevel));
        }
    }

    public int setLevel(UUID playerId, int level) {
        int targetLevel = Math.max(level, 1);
        PlayerLevelData data = this.get(playerId);
        int oldLevel = this.getLevel(playerId);
        long targetXp = this.getXpForLevel(targetLevel);
        this.setDataXP(data, targetXp);
        int newLevel = this.getLevel(playerId);
        if (newLevel > oldLevel) {
            this.levelUpListeners.forEach(l -> l.onLevelUp(playerId, newLevel));
        } else if (newLevel < oldLevel) {
            this.levelDownListeners.forEach(l -> l.onLevelDown(playerId, newLevel));
        }
        return newLevel;
    }

    public long getXpForLevel(int level) {
        if (level <= 1) {
            return 0L;
        }
        return this.formula.getXpForLevel(level);
    }

    public void addXp(UUID id, long amount) {
        PlayerLevelData data = this.get(id);
        int oldLevel = this.getLevel(id);
        this.setDataXP(data, data.getXp() + amount);
        this.xpGainListeners.forEach(l -> l.onXpGain(id, amount));
        int newLevel = this.getLevel(id);
        if (newLevel > oldLevel) {
            this.levelUpListeners.forEach(l -> l.onLevelUp(id, newLevel));
        }
    }

    public void removeXp(UUID id, long amount) {
        PlayerLevelData data = this.get(id);
        int oldLevel = this.getLevel(id);
        this.setDataXP(data, data.getXp() - amount);
        this.xpLossListeners.forEach(l -> l.onXpLoss(id, amount));
        int newLevel = this.getLevel(id);
        if (newLevel < oldLevel) {
            this.levelDownListeners.forEach(l -> l.onLevelDown(id, newLevel));
        }
    }

    public void setXp(UUID id, long xp) {
        PlayerLevelData data = this.get(id);
        int oldLevel = this.getLevel(id);
        this.setDataXP(data, xp);
        int newLevel = this.getLevel(id);
        if (newLevel > oldLevel) {
            this.levelUpListeners.forEach(l -> l.onLevelUp(id, newLevel));
        } else if (newLevel < oldLevel) {
            this.levelDownListeners.forEach(l -> l.onLevelDown(id, newLevel));
        }
    }

    public void registerLevelDownListener(LevelDownListener listener) {
        this.levelDownListeners.add(listener);
    }

    public List<LevelDownListener> getLevelDownListeners() {
        return this.levelDownListeners;
    }

    public void registerLevelUpListener(LevelUpListener listener) {
        this.levelUpListeners.add(listener);
    }

    public List<LevelUpListener> getLevelUpListeners() {
        return this.levelUpListeners;
    }

    public void registerXpGainListener(XpGainListener listener) {
        this.xpGainListeners.add(listener);
    }

    public List<XpGainListener> getXpGainListeners() {
        return this.xpGainListeners;
    }

    public void registerXpLossListener(XpLossListener listener) {
        this.xpLossListeners.add(listener);
    }

    public List<XpLossListener> getXpLossListeners() {
        return this.xpLossListeners;
    }

    private void setDataXP(PlayerLevelData data, long xp) {
        data.setXp(xp);
        this.repository.save(data);
    }
}

