/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.hud;

import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.level.LevelServiceImpl;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.util.Config;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class XPBarHud
extends CustomUIHud {
    private LevelServiceImpl levelServiceImpl;
    private final Config<GUIConfig> config;

    public XPBarHud(@NonNullDecl PlayerRef playerRef, @NonNullDecl LevelServiceImpl levelServiceImpl, Config<GUIConfig> config) {
        super(playerRef);
        this.levelServiceImpl = levelServiceImpl;
        this.config = config;
    }

    protected void build(@NonNullDecl UICommandBuilder uiCommandBuilder) {
        uiCommandBuilder.append("xpbar.ui");
        this.update(uiCommandBuilder);
    }

    public void update(UICommandBuilder uiCommandBuilder) {
        UUID uuid = this.getPlayerRef().getUuid();
        long currentXp = this.levelServiceImpl.getXp(uuid);
        int currentLevel = this.levelServiceImpl.getLevel(uuid);
        long xpForCurrentLevel = this.levelServiceImpl.getXpForLevel(currentLevel);
        long xpForNextLevel = this.levelServiceImpl.getXpForLevel(currentLevel + 1);
        long xpIntoLevel = currentXp - xpForCurrentLevel;
        long xpNeededThisLevel = xpForNextLevel - xpForCurrentLevel;
        double progress = (double)xpIntoLevel / (double)xpNeededThisLevel;
        uiCommandBuilder.set("#ProgressBar.Value", progress);
        if (((GUIConfig)this.config.get()).isShowXPAmountInHUD()) {
            uiCommandBuilder.set("#Level.TextSpans", Message.raw((String)("LVL: " + currentLevel + "   XP: " + currentXp + " / " + xpForNextLevel)));
        } else {
            uiCommandBuilder.set("#Level.TextSpans", Message.raw((String)("LVL: " + currentLevel)));
        }
        this.update(false, uiCommandBuilder);
    }
}

