/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.exceptions;

import java.sql.SQLException;

public class DataSourceConfigurationException
extends RuntimeException {
    public DataSourceConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static DataSourceConfigurationException from(String context, String jdbcUrl, String username, Throwable cause) {
        Throwable root = DataSourceConfigurationException.rootCause(cause);
        String redacted = DataSourceConfigurationException.redactJdbcUrl(jdbcUrl);
        String base = context + " (jdbcUrl=" + redacted + ", username=" + username + "). ";
        if (root instanceof SQLException) {
            SQLException sqlEx = (SQLException)root;
            return new DataSourceConfigurationException(base + DataSourceConfigurationException.explain(sqlEx), cause);
        }
        if (root instanceof ClassNotFoundException) {
            return new DataSourceConfigurationException(base + "JDBC driver not found on the classpath. Make sure the correct driver dependency is installed for this jdbcUrl.", cause);
        }
        return new DataSourceConfigurationException(base + "Unexpected error while creating/connecting to the datasource: " + root.getClass().getSimpleName() + ": " + DataSourceConfigurationException.safeMsg(root.getMessage()), cause);
    }

    private static String explain(SQLException e) {
        String state = e.getSQLState();
        int code = e.getErrorCode();
        String msg = DataSourceConfigurationException.safeMsg(e.getMessage());
        if (state != null) {
            if (state.startsWith("08")) {
                return "Connection failed (network/host/port/firewall). Check host, port, DB is running, and that the server allows your IP. " + DataSourceConfigurationException.details(state, code, msg);
            }
            if (state.startsWith("28")) {
                return "Authentication failed. Check username/password and account permissions. " + DataSourceConfigurationException.details(state, code, msg);
            }
            if (state.startsWith("3D")) {
                return "Database does not exist (or is not reachable under that name). Check the database name in the JDBC URL. " + DataSourceConfigurationException.details(state, code, msg);
            }
            if (state.startsWith("42")) {
                return "SQL error during initialization (syntax / permissions / missing table/schema). " + DataSourceConfigurationException.details(state, code, msg);
            }
        }
        return "Database error while connecting. " + DataSourceConfigurationException.details(state, code, msg);
    }

    private static String details(String state, int code, String msg) {
        String s2 = state == null ? "n/a" : state;
        return "Root cause: " + msg + " (SQLSTATE=" + s2 + ", vendorCode=" + code + ")";
    }

    private static Throwable rootCause(Throwable t2) {
        Throwable cur;
        for (cur = t2; cur.getCause() != null && cur.getCause() != cur; cur = cur.getCause()) {
        }
        return cur;
    }

    private static String safeMsg(String msg) {
        return msg == null ? "no message" : msg;
    }

    private static String redactJdbcUrl(String jdbcUrl) {
        if (jdbcUrl == null) {
            return "null";
        }
        return jdbcUrl.replaceAll("(//[^/@]*:)[^@]*@", "$1****@");
    }
}

