/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.database;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.config.internal.FormulaDescriptor;
import com.azuredoom.levelingcore.config.internal.LevelFormulaFactory;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import com.azuredoom.levelingcore.playerdata.PlayerLevelData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.sql.DataSource;

public class JdbcLevelRepository {
    private final DataSource dataSource;

    public JdbcLevelRepository(DataSource dataSource) {
        this.dataSource = dataSource;
        this.createTableIfNotExists();
    }

    private void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS player_levels (\n    player_id VARCHAR(36) PRIMARY KEY,\n    xp BIGINT NOT NULL\n)\n";
        try (Connection connection = this.dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute(sql);
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to create player_levels table", e);
        }
    }

    private void createMetaTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS levelingcore_meta (\n    meta_key VARCHAR(64) PRIMARY KEY,\n    meta_value VARCHAR(255) NOT NULL\n)\n";
        try (Connection c = this.dataSource.getConnection();
             Statement s2 = c.createStatement();){
            s2.execute(sql);
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to create levelingcore_meta table", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String metaGet(String key) {
        String sql = "SELECT meta_value FROM levelingcore_meta WHERE meta_key = ?";
        try (Connection c = this.dataSource.getConnection();){
            String string;
            block14: {
                PreparedStatement ps = c.prepareStatement(sql);
                try {
                    ps.setString(1, key);
                    ResultSet rs = ps.executeQuery();
                    String string2 = string = rs.next() ? rs.getString(1) : null;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to read meta key: " + key, e);
        }
    }

    private void metaPut(String key, String value) {
        block21: {
            String update = "UPDATE levelingcore_meta SET meta_value = ? WHERE meta_key = ?";
            String insert = "INSERT INTO levelingcore_meta (meta_key, meta_value) VALUES (?, ?)";
            try (Connection c = this.dataSource.getConnection();){
                int changed;
                try (PreparedStatement ps = c.prepareStatement(update);){
                    ps.setString(1, value);
                    ps.setString(2, key);
                    changed = ps.executeUpdate();
                }
                if (changed != 0) break block21;
                ps = c.prepareStatement(insert);
                try {
                    ps.setString(1, key);
                    ps.setString(2, value);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                throw new LevelingCoreException("Failed to write meta key: " + key, e);
            }
        }
    }

    public void migrateFormulaIfNeeded(LevelFormula newFormula, FormulaDescriptor newDesc) {
        this.createMetaTableIfNotExists();
        String oldType = this.metaGet("formula.type");
        String oldParams = this.metaGet("formula.params");
        if (oldType == null || oldParams == null) {
            this.metaPut("formula.type", newDesc.type());
            this.metaPut("formula.params", newDesc.params());
            return;
        }
        if (oldType.equalsIgnoreCase(newDesc.type()) && oldParams.equals(newDesc.params())) {
            return;
        }
        LevelFormula oldFormula = LevelFormulaFactory.formulaFromDescriptor(new FormulaDescriptor(oldType, oldParams));
        LevelingCore.LOGGER.at(Level.INFO).log("Starting formula migration to {0}", (Object)newDesc.type());
        String select = "SELECT player_id, xp FROM player_levels";
        String createTemp = "CREATE TEMP TABLE IF NOT EXISTS tmp_player_xp (  player_id UUID PRIMARY KEY,  xp BIGINT)";
        String truncateTemp = "TRUNCATE TABLE tmp_player_xp";
        String insertTemp = "INSERT INTO tmp_player_xp (player_id, xp) VALUES (?, ?)";
        try (Connection c = this.dataSource.getConnection();){
            c.setAutoCommit(false);
            try (Statement st2 = c.createStatement();){
                st2.execute("SET WRITE_DELAY 1000");
                st2.execute("SET LOCK_MODE 0");
            }
            catch (Exception st2) {
                // empty catch block
            }
            HashMap<Integer, Long> levelToNewXp = new HashMap<Integer, Long>(1024);
            try (Statement st = c.createStatement();){
                st.execute("CREATE TEMP TABLE IF NOT EXISTS tmp_player_xp (  player_id UUID PRIMARY KEY,  xp BIGINT)");
                st.execute("TRUNCATE TABLE tmp_player_xp");
            }
            try (PreparedStatement psSel = c.prepareStatement("SELECT player_id, xp FROM player_levels", 1003, 1007);
                 PreparedStatement psIns = c.prepareStatement("INSERT INTO tmp_player_xp (player_id, xp) VALUES (?, ?)");){
                psSel.setFetchSize(10000);
                int batch = 0;
                int processed = 0;
                try (ResultSet rs = psSel.executeQuery();){
                    while (rs.next()) {
                        long newXp;
                        UUID playerId = rs.getObject(1, UUID.class);
                        long oldXp = rs.getLong(2);
                        int level = oldFormula.getLevelForXp(oldXp);
                        Long newXpObj = (Long)levelToNewXp.get(level);
                        if (newXpObj != null) {
                            newXp = newXpObj;
                        } else {
                            newXp = newFormula.getXpForLevel(level);
                            levelToNewXp.put(level, newXp);
                        }
                        psIns.setObject(1, playerId);
                        psIns.setLong(2, newXp);
                        psIns.addBatch();
                        if (++batch >= 10000) {
                            psIns.executeBatch();
                            batch = 0;
                        }
                        if (++processed % 50000 != 0) continue;
                        LevelingCore.LOGGER.at(Level.INFO).log("Migration staging progress: {0} rows", processed);
                    }
                }
                if (batch > 0) {
                    psIns.executeBatch();
                }
            }
            c.commit();
            LevelingCore.LOGGER.at(Level.INFO).log("Formula migration completed successfully");
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to migrate XP to preserve levels", e);
        }
        this.metaPut("formula.type", newDesc.type());
        this.metaPut("formula.params", newDesc.params());
    }

    public void save(PlayerLevelData data) {
        block21: {
            String updateSql = "UPDATE player_levels SET xp = ? WHERE player_id = ?";
            String insertSql = "INSERT INTO player_levels (player_id, xp) VALUES (?, ?)";
            try (Connection connection = this.dataSource.getConnection();){
                int updated;
                try (PreparedStatement ps = connection.prepareStatement(updateSql);){
                    ps.setLong(1, data.getXp());
                    ps.setString(2, data.getPlayerId().toString());
                    updated = ps.executeUpdate();
                }
                if (updated != 0) break block21;
                ps = connection.prepareStatement(insertSql);
                try {
                    ps.setString(1, data.getPlayerId().toString());
                    ps.setLong(2, data.getXp());
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                throw new LevelingCoreException("Failed to save player level data", e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PlayerLevelData load(UUID id) {
        String sql = "SELECT xp FROM player_levels WHERE player_id = ?";
        try (Connection connection = this.dataSource.getConnection();){
            PlayerLevelData playerLevelData;
            block18: {
                PreparedStatement ps;
                block16: {
                    PlayerLevelData playerLevelData2;
                    block17: {
                        ps = connection.prepareStatement(sql);
                        try {
                            ps.setString(1, id.toString());
                            ResultSet rs = ps.executeQuery();
                            if (!rs.next()) break block16;
                            PlayerLevelData data = new PlayerLevelData(id);
                            data.setXp(rs.getLong("xp"));
                            playerLevelData2 = data;
                            if (ps == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (ps != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ps.close();
                    }
                    return playerLevelData2;
                }
                playerLevelData = null;
                if (ps == null) break block18;
                ps.close();
            }
            return playerLevelData;
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to load player level data", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean exists(UUID id) {
        String sql = "SELECT 1 FROM player_levels WHERE player_id = ?";
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(sql);
                try {
                    ps.setString(1, id.toString());
                    ResultSet rs = ps.executeQuery();
                    bl = rs.next();
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw new LevelingCoreException("exists() failed", e);
        }
    }

    public void close() {
        try {
            DataSource dataSource = this.dataSource;
            if (dataSource instanceof AutoCloseable) {
                AutoCloseable c = (AutoCloseable)((Object)dataSource);
                LevelingCore.LOGGER.at(Level.INFO).log("Closing JDBC datasource");
                c.close();
            }
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to close JDBC datasource", e);
        }
    }
}

