/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.database;

import com.azuredoom.levelingcore.exceptions.DataSourceConfigurationException;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;

public final class DataSourceFactory {
    private DataSourceFactory() {
    }

    public static HikariDataSource create(String jdbcUrl, String username, String password, int maxPoolSize) {
        HikariDataSource ds;
        DataSourceFactory.validateBasicConfig(jdbcUrl, username, maxPoolSize);
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(jdbcUrl);
        if (username != null && !username.isBlank()) {
            cfg.setUsername(username);
            cfg.setPassword(password);
        }
        cfg.setDriverClassName(DataSourceFactory.driverClassNameFor(jdbcUrl));
        cfg.setMaximumPoolSize(maxPoolSize);
        cfg.setMinimumIdle(1);
        cfg.setInitializationFailTimeout(10000L);
        cfg.setConnectionTimeout(10000L);
        cfg.setValidationTimeout(5000L);
        try {
            ds = new HikariDataSource(cfg);
        }
        catch (RuntimeException e) {
            throw DataSourceConfigurationException.from("Failed to initialize connection pool", jdbcUrl, username, e);
        }
        try (Connection c = ds.getConnection();){
            c.isValid(2);
        }
        catch (Exception e) {
            try {
                ds.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataSourceConfigurationException.from("Database connection test failed", jdbcUrl, username, e);
        }
        return ds;
    }

    private static boolean hasUserInfoAuthority(String jdbcUrl) {
        return jdbcUrl != null && jdbcUrl.matches("^jdbc:postgresql://[^/@:]+:[^/@]+@.+");
    }

    private static boolean hasCredentialsInJdbcUrl(String jdbcUrl) {
        if (jdbcUrl == null) {
            return false;
        }
        String lower = jdbcUrl.toLowerCase();
        if (lower.matches("^jdbc:[^:]+://[^/@:]+:[^/@]+@.+")) {
            return true;
        }
        int q = lower.indexOf(63);
        if (q < 0) {
            return false;
        }
        String query = lower.substring(q + 1);
        return DataSourceFactory.containsQueryParam(query, "user") || DataSourceFactory.containsQueryParam(query, "username") || DataSourceFactory.containsQueryParam(query, "password");
    }

    private static boolean containsQueryParam(String query, String key) {
        return query.startsWith(key + "=") || query.contains("&" + key + "=");
    }

    private static boolean isH2(String jdbcUrl) {
        return jdbcUrl != null && jdbcUrl.toLowerCase().startsWith("jdbc:h2:");
    }

    private static void validateBasicConfig(String jdbcUrl, String username, int maxPoolSize) {
        if (jdbcUrl == null || jdbcUrl.isBlank()) {
            throw new IllegalArgumentException("jdbcUrl is missing/blank (example: jdbc:postgresql://host:5432/db)");
        }
        if (!jdbcUrl.toLowerCase().startsWith("jdbc:")) {
            throw new IllegalArgumentException("jdbcUrl must start with 'jdbc:' (got: " + jdbcUrl + ")");
        }
        if (jdbcUrl.toLowerCase().startsWith("jdbc:postgresql:") && DataSourceFactory.hasUserInfoAuthority(jdbcUrl)) {
            throw new IllegalArgumentException("PostgreSQL JDBC URLs must not use 'user:password@host' syntax. Use either:\n  - jdbc:postgresql://host:port/db with dedicated username/password, or\n  - jdbc:postgresql://host:port/db?user=...&password=...");
        }
        boolean hasUserArg = username != null && !username.isBlank();
        boolean hasUrlCreds = DataSourceFactory.hasCredentialsInJdbcUrl(jdbcUrl);
        if (!(DataSourceFactory.isH2(jdbcUrl) || hasUserArg || hasUrlCreds)) {
            throw new IllegalArgumentException("database credentials are missing (provide username/password or embed them in jdbcUrl)");
        }
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be >= 1 (got: " + maxPoolSize + ")");
        }
    }

    private static String driverClassNameFor(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.cj.jdbc.Driver";
        }
        if (url.startsWith("jdbc:mariadb:")) {
            return "org.mariadb.jdbc.Driver";
        }
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (url.startsWith("jdbc:h2:")) {
            return "org.h2.Driver";
        }
        throw new IllegalArgumentException("Unsupported jdbcUrl scheme. Supported: mysql, mariadb, postgresql, h2. Got: " + jdbcUrl);
    }
}

