/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.config.internal;

import com.azuredoom.levelingcore.config.internal.FormulaDescriptor;
import com.azuredoom.levelingcore.config.internal.LevelingCoreConfig;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.formulas.CustomExpressionLevelFormula;
import com.azuredoom.levelingcore.level.formulas.ExponentialLevelFormula;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import com.azuredoom.levelingcore.level.formulas.LinearLevelFormula;
import com.azuredoom.levelingcore.level.formulas.loader.LevelTableLoader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public final class LevelFormulaFactory {
    private LevelFormulaFactory() {
    }

    public static LevelFormula fromConfig(LevelingCoreConfig config) {
        String type;
        if (config == null || config.formula == null || config.formula.type == null) {
            return new ExponentialLevelFormula(100.0, 1.7, 100000);
        }
        return switch (type = config.formula.type.trim().toUpperCase(Locale.ROOT)) {
            case "EXPONENTIAL" -> {
                double baseXp = config.formula.exponential.baseXp;
                double exponent = config.formula.exponential.exponent;
                int maxLevel = config.formula.exponential.maxLevel;
                yield new ExponentialLevelFormula(baseXp, exponent, maxLevel);
            }
            case "LINEAR" -> {
                long xpPerLevel = config.formula.linear.xpPerLevel;
                int maxLevel = config.formula.linear.maxLevel;
                yield new LinearLevelFormula(xpPerLevel, maxLevel);
            }
            case "TABLE" -> LevelTableLoader.loadOrCreateFromDataDir(config.formula.table.file);
            case "CUSTOM" -> {
                String expr = config.formula.custom.xpForLevel;
                Map<String, Double> constants = config.formula.custom.constants;
                int maxLevel = config.formula.custom.maxLevel;
                yield new CustomExpressionLevelFormula(expr, constants, maxLevel);
            }
            default -> throw new LevelingCoreException("Unknown formula.type '" + config.formula.type + "'. Expected EXPONENTIAL or LINEAR.");
        };
    }

    public static FormulaDescriptor descriptorFromConfig(LevelingCoreConfig cfg) {
        String type;
        return switch (type = cfg.formula.type.trim().toUpperCase(Locale.ROOT)) {
            case "EXPONENTIAL" -> new FormulaDescriptor("EXPONENTIAL", "baseXp=" + cfg.formula.exponential.baseXp + ";exponent=" + cfg.formula.exponential.exponent);
            case "LINEAR" -> new FormulaDescriptor("LINEAR", "xpPerLevel=" + cfg.formula.linear.xpPerLevel);
            case "TABLE" -> new FormulaDescriptor("TABLE", "file=" + cfg.formula.table.file);
            case "CUSTOM" -> {
                String expr = cfg.formula.custom.xpForLevel == null ? "" : cfg.formula.custom.xpForLevel;
                String exprB64 = LevelFormulaFactory.b64(expr);
                String constantsB64 = LevelFormulaFactory.encodeConstants(cfg.formula.custom.constants);
                int maxLevel = cfg.formula.custom.maxLevel;
                yield new FormulaDescriptor("CUSTOM", "exprB64=" + exprB64 + ";constB64=" + constantsB64 + ";maxLevel=" + maxLevel);
            }
            default -> throw new LevelingCoreException("Unknown formula.type: " + cfg.formula.type);
        };
    }

    public static LevelFormula formulaFromDescriptor(FormulaDescriptor d) {
        String[] type = d.type().trim().toUpperCase(Locale.ROOT);
        HashMap<String, String> map = new HashMap<String, String>();
        if (d.params() != null && !d.params().isBlank()) {
            for (String part : d.params().split(";")) {
                String[] kv = part.split("=", 2);
                if (kv.length != 2) continue;
                map.put(kv[0].trim(), kv[1].trim());
            }
        }
        return switch (type) {
            case "EXPONENTIAL" -> new ExponentialLevelFormula(Double.parseDouble(map.getOrDefault("baseXp", "100.0")), Double.parseDouble(map.getOrDefault("exponent", "1.7")), Integer.parseInt(map.getOrDefault("maxLevel", "100000")));
            case "LINEAR" -> new LinearLevelFormula(Long.parseLong(map.getOrDefault("xpPerLevel", "100")), Integer.parseInt(map.getOrDefault("maxLevel", "100000")));
            case "TABLE" -> {
                String file = map.getOrDefault("file", "levels.csv");
                yield LevelTableLoader.loadOrCreateFromDataDir(file);
            }
            case "CUSTOM" -> {
                String expr = LevelFormulaFactory.unb64(map.getOrDefault("exprB64", LevelFormulaFactory.b64("")));
                Map<String, Double> constants = LevelFormulaFactory.decodeConstants(map.getOrDefault("constB64", ""));
                int maxLevel = Integer.parseInt(map.getOrDefault("maxLevel", "100000"));
                yield new CustomExpressionLevelFormula(expr, constants, maxLevel);
            }
            default -> throw new LevelingCoreException("Unknown stored formula.type: " + d.type());
        };
    }

    private static String b64(String s2) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(s2.getBytes(StandardCharsets.UTF_8));
    }

    private static String unb64(String s2) {
        return new String(Base64.getUrlDecoder().decode(s2), StandardCharsets.UTF_8);
    }

    private static String encodeConstants(Map<String, Double> constants) {
        if (constants == null || constants.isEmpty()) {
            return "";
        }
        String raw = constants.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(","));
        return LevelFormulaFactory.b64(raw);
    }

    private static Map<String, Double> decodeConstants(String b64) {
        HashMap<String, Double> out = new HashMap<String, Double>();
        if (b64 == null || b64.isBlank()) {
            return out;
        }
        String raw = LevelFormulaFactory.unb64(b64);
        if (raw.isBlank()) {
            return out;
        }
        for (String part : raw.split(",")) {
            String[] kv = part.split("=", 2);
            if (kv.length != 2) continue;
            out.put(kv[0].trim(), Double.parseDouble(kv[1].trim()));
        }
        return out;
    }
}

