/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.config.internal;

import com.azuredoom.levelingcore.LevelingCore;
import com.azuredoom.levelingcore.config.internal.LevelingCoreConfig;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public final class ConfigManager {
    private ConfigManager() {
    }

    public static LevelingCoreConfig loadOrCreate(Path dataDir) {
        LevelingCoreConfig levelingCoreConfig;
        block19: {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            Path configPath = dataDir.resolve("levelingcore.yml");
            if (Files.notExists(configPath, new LinkOption[0])) {
                try (InputStream in = ConfigManager.class.getResourceAsStream("/default.yml");){
                    if (in == null) {
                        throw new LevelingCoreException("default.yml not found in resources (expected at /default.yml)");
                    }
                    LevelingCore.LOGGER.at(Level.INFO).log("Creating default config at {0}", (Object)configPath);
                    Files.copy(in, configPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new LevelingCoreException("Failed to create default config", e);
                }
            }
            LoaderOptions opts = new LoaderOptions();
            opts.setMaxAliasesForCollections(50);
            Yaml yaml = new Yaml(new Constructor(LevelingCoreConfig.class, opts));
            BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);
            try {
                LevelingCoreConfig cfg = (LevelingCoreConfig)yaml.load(reader);
                LevelingCore.LOGGER.at(Level.INFO).log("Loaded config from {0}", (Object)configPath);
                LevelingCoreConfig levelingCoreConfig2 = levelingCoreConfig = cfg != null ? cfg : new LevelingCoreConfig();
                if (reader == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new LevelingCoreException("Failed to load config", e);
                }
            }
            reader.close();
        }
        return levelingCoreConfig;
    }
}

