/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.config.internal;

import com.azuredoom.levelingcore.config.internal.ConfigManager;
import com.azuredoom.levelingcore.config.internal.FormulaDescriptor;
import com.azuredoom.levelingcore.config.internal.LevelFormulaFactory;
import com.azuredoom.levelingcore.config.internal.LevelingCoreConfig;
import com.azuredoom.levelingcore.database.DataSourceFactory;
import com.azuredoom.levelingcore.database.JdbcLevelRepository;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.LevelServiceImpl;
import com.azuredoom.levelingcore.level.formulas.LevelFormula;
import com.azuredoom.levelingcore.level.rewards.LevelRewards;
import com.azuredoom.levelingcore.level.rewards.RewardEntry;
import com.azuredoom.levelingcore.level.xp.XPValues;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public final class ConfigBootstrap {
    private ConfigBootstrap() {
    }

    public static Bootstrap bootstrap(Path dataDir) {
        if (dataDir == null) {
            throw new LevelingCoreException("dataDir cannot be null");
        }
        LevelingCoreConfig config = ConfigManager.loadOrCreate(dataDir);
        FormulaDescriptor formulaDescriptor = LevelFormulaFactory.descriptorFromConfig(config);
        LevelFormula formula = LevelFormulaFactory.fromConfig(config);
        HikariDataSource ds = DataSourceFactory.create(config.database.jdbcUrl, config.database.username, config.database.password, config.database.maxPoolSize);
        JdbcLevelRepository repo = new JdbcLevelRepository(ds);
        if (config.formula.migrateXP.booleanValue()) {
            repo.migrateFormulaIfNeeded(formula, formulaDescriptor);
        }
        LevelServiceImpl service = new LevelServiceImpl(formula, repo);
        Map<String, Integer> xpMapping = XPValues.loadOrCreate(dataDir);
        Map<Integer, List<RewardEntry>> levelRewardMapping = LevelRewards.loadOrCreate(dataDir);
        return new Bootstrap(service, xpMapping, levelRewardMapping, repo::close);
    }

    public record Bootstrap(LevelServiceImpl service, Map<String, Integer> xpMapping, Map<Integer, List<RewardEntry>> levelRewardMapping, AutoCloseable closeable) {
    }
}

