/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.compat;

import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.level.LevelServiceImpl;
import com.azuredoom.levelingcore.utils.NotificationsUtil;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.util.Config;
import java.util.Arrays;
import java.util.UUID;
import net.justmadlime.SimpleParty.party.PartyInfo;
import net.justmadlime.SimpleParty.party.PartyManager;

public class SimplePartyCompat {
    public static void onXPGain(long xp, UUID playerUuid, LevelServiceImpl levelService, Config<GUIConfig> config, PlayerRef playerRef) {
        PartyInfo party = PartyManager.getInstance().getPartyFromPlayer(playerUuid);
        if (party != null && ((GUIConfig)config.get()).isEnableSimplePartyXPShareCompat()) {
            Arrays.stream(party.getAllPartyMembers()).distinct().forEach(uuid -> {
                NotificationsUtil.sendNotification(Universe.get().getPlayer(uuid), "Gained " + xp + " XP");
                levelService.addXp((UUID)uuid, xp);
            });
        } else {
            NotificationsUtil.sendNotification(playerRef, "Gained " + xp + " XP");
            levelService.addXp(playerUuid, xp);
        }
    }
}

