/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.commands;

import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.lang.CommandLang;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.permissions.HytalePermissions;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import com.hypixel.hytale.server.core.util.EventTitleUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class CheckLevelCommand
extends AbstractPlayerCommand {
    @Nonnull
    private final RequiredArg<PlayerRef> playerArg;
    private final Config<GUIConfig> config;

    public CheckLevelCommand(Config<GUIConfig> config) {
        super("checklevel", "Check level of player");
        this.requirePermission(HytalePermissions.fromCommand((String)"levelingcore.checklevel"));
        this.config = config;
        this.playerArg = this.withRequiredArg("player", "server.commands.levelingcore.checklevel.desc", (ArgumentType)ArgTypes.PLAYER_REF);
    }

    protected void execute(@NonNullDecl CommandContext commandContext, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (LevelingCoreApi.getLevelServiceIfPresent().isEmpty()) {
            commandContext.sendMessage(CommandLang.NOT_INITIALIZED);
            return;
        }
        playerRef = (PlayerRef)this.playerArg.get(commandContext);
        UUID playerUUID = playerRef.getUuid();
        int levelRef = LevelingCoreApi.getLevelServiceIfPresent().get().getLevel(playerUUID);
        Message currentLevelMsg = CommandLang.CHECK_LEVEL.param("player", playerRef.getUsername()).param("level", levelRef);
        if (((GUIConfig)this.config.get()).isEnableLevelAndXPTitles()) {
            EventTitleUtil.showEventTitleToPlayer((PlayerRef)playerRef, (Message)currentLevelMsg, (Message)Message.raw((String)""), (boolean)true);
        }
        commandContext.sendMessage(currentLevelMsg);
    }
}

