/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore.commands;

import com.azuredoom.levelingcore.api.LevelingCoreApi;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.lang.CommandLang;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.permissions.HytalePermissions;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import com.hypixel.hytale.server.core.util.EventTitleUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class AddXpCommand
extends AbstractPlayerCommand {
    @Nonnull
    private final RequiredArg<PlayerRef> playerArg;
    @Nonnull
    private final RequiredArg<Integer> xpArg;
    private final Config<GUIConfig> config;

    public AddXpCommand(Config<GUIConfig> config) {
        super("addxp", "Add XP to player");
        this.requirePermission(HytalePermissions.fromCommand((String)"levelingcore.addxp"));
        this.config = config;
        this.playerArg = this.withRequiredArg("player", "server.commands.levelingcore.addlevel.desc", (ArgumentType)ArgTypes.PLAYER_REF);
        this.xpArg = this.withRequiredArg("xpvalue", "server.commands.levelingcore.addlevel.desc", (ArgumentType)ArgTypes.INTEGER);
    }

    protected void execute(@NonNullDecl CommandContext commandContext, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (LevelingCoreApi.getLevelServiceIfPresent().isEmpty()) {
            commandContext.sendMessage(CommandLang.NOT_INITIALIZED);
            return;
        }
        playerRef = (PlayerRef)this.playerArg.get(commandContext);
        Integer xpRef = (Integer)this.xpArg.get(commandContext);
        UUID playerUUID = playerRef.getUuid();
        LevelingCoreApi.getLevelServiceIfPresent().get().addXp(playerUUID, xpRef.intValue());
        int level = LevelingCoreApi.getLevelServiceIfPresent().get().getLevel(playerUUID);
        Message setXPMsg = CommandLang.ADD_XP_1.param("xp", xpRef.intValue()).param("player", playerRef.getUsername());
        Message levelTotalMsg = CommandLang.ADD_XP_2.param("player", playerRef.getUsername()).param("level", level);
        if (((GUIConfig)this.config.get()).isEnableLevelAndXPTitles()) {
            EventTitleUtil.showEventTitleToPlayer((PlayerRef)playerRef, (Message)levelTotalMsg, (Message)setXPMsg, (boolean)true);
        }
        commandContext.sendMessage(setXPMsg);
        commandContext.sendMessage(levelTotalMsg);
    }
}

