/*
 * Decompiled with CFR 0.152.
 */
package com.azuredoom.levelingcore;

import com.azuredoom.levelingcore.commands.AddLevelCommand;
import com.azuredoom.levelingcore.commands.AddXpCommand;
import com.azuredoom.levelingcore.commands.CheckLevelCommand;
import com.azuredoom.levelingcore.commands.RemoveLevelCommand;
import com.azuredoom.levelingcore.commands.RemoveXpCommand;
import com.azuredoom.levelingcore.commands.SetLevelCommand;
import com.azuredoom.levelingcore.config.GUIConfig;
import com.azuredoom.levelingcore.config.internal.ConfigBootstrap;
import com.azuredoom.levelingcore.exceptions.LevelingCoreException;
import com.azuredoom.levelingcore.level.LevelServiceImpl;
import com.azuredoom.levelingcore.systems.GainXPEventSystem;
import com.azuredoom.levelingcore.systems.LevelDownTickingSystem;
import com.azuredoom.levelingcore.systems.LevelUpTickingSystem;
import com.azuredoom.levelingcore.systems.LossXPEventSystem;
import com.azuredoom.levelingcore.systems.XPTickSystem;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.util.Config;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class LevelingCore
extends JavaPlugin {
    public static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    public static final Path configPath = Paths.get("./mods/levelingcore_LevelingCore/data/config/", new String[0]);
    public static final ConfigBootstrap.Bootstrap bootstrap = ConfigBootstrap.bootstrap(configPath);
    public static LevelServiceImpl levelingService;
    private static LevelingCore INSTANCE;
    private final Config<GUIConfig> config;

    public LevelingCore(@Nonnull JavaPluginInit init) {
        super(init);
        INSTANCE = this;
        this.config = this.withConfig("levelingcore", GUIConfig.CODEC);
    }

    protected void setup() {
        INSTANCE = this;
        this.config.save();
        LOGGER.at(Level.INFO).log("Leveling Core initializing");
        levelingService = bootstrap.service();
        this.registerAllCommands();
        this.registerAllSystems();
    }

    protected void shutdown() {
        super.shutdown();
        LOGGER.at(Level.INFO).log("Leveling Core shutting down");
        try {
            bootstrap.closeable().close();
        }
        catch (Exception e) {
            throw new LevelingCoreException("Failed to close resources", e);
        }
    }

    public static LevelServiceImpl getLevelService() {
        return levelingService;
    }

    public static LevelingCore getInstance() {
        return INSTANCE;
    }

    public void registerAllCommands() {
        this.getCommandRegistry().registerCommand((AbstractCommand)new AddLevelCommand(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new CheckLevelCommand(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new AddXpCommand(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new SetLevelCommand(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new RemoveLevelCommand(this.config));
        this.getCommandRegistry().registerCommand((AbstractCommand)new RemoveXpCommand(this.config));
    }

    public void registerAllSystems() {
        this.getEntityStoreRegistry().registerSystem((ISystem)new XPTickSystem(this.config));
        this.getEntityStoreRegistry().registerSystem((ISystem)new LevelUpTickingSystem(this.config));
        this.getEntityStoreRegistry().registerSystem((ISystem)new LevelDownTickingSystem(this.config));
        this.getEntityStoreRegistry().registerSystem((ISystem)new GainXPEventSystem(this.config));
        this.getEntityStoreRegistry().registerSystem((ISystem)new LossXPEventSystem(this.config));
    }
}

