/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.luckymining;

import com.buuz135.luckymining.LMConfig;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.ecs.BreakBlockEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.ParticleUtil;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BreakBlockEventSystem
extends EntityEventSystem<EntityStore, BreakBlockEvent> {
    private final Random random = new Random();
    public static HashMap<UUID, LuckyMiningInfo> luckyMiningInfo = new HashMap();
    private final Config<LMConfig> config;

    public BreakBlockEventSystem(Config<LMConfig> config) {
        super(BreakBlockEvent.class);
        this.config = config;
    }

    public void handle(int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer, @Nonnull BreakBlockEvent event) {
        Ref ref = archetypeChunk.getReferenceTo(index);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        String block = event.getBlockType().getId();
        if (block.equals("Empty")) {
            return;
        }
        UUID uuid = ((PlayerRef)store.getComponent(ref, PlayerRef.getComponentType())).getUuid();
        if (luckyMiningInfo.containsKey(uuid) && (System.currentTimeMillis() > BreakBlockEventSystem.luckyMiningInfo.get((Object)uuid).lastBreak + (long)((LMConfig)this.config.get()).getMaxTime() * 1000L || !BreakBlockEventSystem.luckyMiningInfo.get((Object)uuid).block.equals(block))) {
            luckyMiningInfo.remove(uuid);
        }
        for (String whitelistOre : ((LMConfig)this.config.get()).getWhitelistOres()) {
            if (!block.contains(whitelistOre)) continue;
            if (luckyMiningInfo.containsKey(uuid) && this.random.nextDouble() < BreakBlockEventSystem.luckyMiningInfo.get((Object)uuid).chance) {
                Vector3d[] checking = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0)};
                ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
                for (Vector3d direction : checking) {
                    BlockType blockType = player.getWorld().getBlockType((int)(direction.x + (double)event.getTargetBlock().x), (int)(direction.y + (double)event.getTargetBlock().y), (int)(direction.z + (double)event.getTargetBlock().z));
                    if (!Arrays.asList(((LMConfig)this.config.get()).getWhitelistReplaceBlocks()).contains(blockType.getId()) || !this.anyAirBlockOrOre(player.getWorld(), (int)(direction.x + (double)event.getTargetBlock().x), (int)(direction.y + (double)event.getTargetBlock().y), (int)(direction.z + (double)event.getTargetBlock().z), block)) continue;
                    positions.add(new Vector3d(direction.x + (double)event.getTargetBlock().x, direction.y + (double)event.getTargetBlock().y, direction.z + (double)event.getTargetBlock().z));
                }
                if (positions.isEmpty()) {
                    for (int x = -1; x < 1; ++x) {
                        for (int y = -1; y < 1; ++y) {
                            for (int z = -1; z < 1; ++z) {
                                BlockType blockType = player.getWorld().getBlockType(x + event.getTargetBlock().x, y + event.getTargetBlock().y, z + event.getTargetBlock().z);
                                if (!Arrays.asList(((LMConfig)this.config.get()).getWhitelistReplaceBlocks()).contains(blockType.getId()) || !this.anyAirBlockOrOre(player.getWorld(), x + event.getTargetBlock().x, y + event.getTargetBlock().y, z + event.getTargetBlock().z, block)) continue;
                                positions.add(new Vector3d((double)(x + event.getTargetBlock().x), (double)(y + event.getTargetBlock().y), (double)(z + event.getTargetBlock().z)));
                            }
                        }
                    }
                }
                if (!positions.isEmpty()) {
                    Vector3d randomPosition = (Vector3d)positions.get(this.random.nextInt(positions.size()));
                    player.getWorld().setBlock((int)randomPosition.x, (int)randomPosition.y, (int)randomPosition.z, block);
                    for (double i = 0.0; i <= 1.0; i += 0.1) {
                        for (double j = 0.0; j <= 1.0; j += 0.1) {
                            ParticleUtil.spawnParticleEffect((String)"Buuz135_LuckyMining_Spawn", (Vector3d)new Vector3d(randomPosition.x + i, randomPosition.y, randomPosition.z + j), store);
                            ParticleUtil.spawnParticleEffect((String)"Buuz135_LuckyMining_Spawn_Still", (Vector3d)new Vector3d(randomPosition.x + i, randomPosition.y + 1.0, randomPosition.z + j), store);
                        }
                    }
                    SoundUtil.playSoundEvent2dToPlayer((PlayerRef)((PlayerRef)store.getComponent(ref, PlayerRef.getComponentType())), (int)SoundEvent.getAssetMap().getIndex((Object)"SFX_Buuz135_LuckyMining_Lucky"), (SoundCategory)SoundCategory.SFX, (float)3.0f, (float)1.0f);
                }
                BreakBlockEventSystem.luckyMiningInfo.get((Object)uuid).lastBreak = System.currentTimeMillis();
            }
            if (luckyMiningInfo.containsKey(uuid)) {
                BreakBlockEventSystem.luckyMiningInfo.get((Object)uuid).chance += ((LMConfig)this.config.get()).getLuckIncreaseChance();
                break;
            }
            luckyMiningInfo.put(uuid, new LuckyMiningInfo(block, ((LMConfig)this.config.get()).getLuckStartChance(), System.currentTimeMillis()));
            break;
        }
    }

    public boolean anyAirBlockOrOre(World world, int x, int y, int z, String ore) {
        return this.checkAirBlockOrOre(world, x + 1, y, z, ore) || this.checkAirBlockOrOre(world, x - 1, y, z, ore) || this.checkAirBlockOrOre(world, x, y + 1, z, ore) || this.checkAirBlockOrOre(world, x, y - 1, z, ore) || this.checkAirBlockOrOre(world, x, y, z + 1, ore) || this.checkAirBlockOrOre(world, x, y, z - 1, ore);
    }

    public boolean checkAirBlockOrOre(World world, int x, int y, int z, String ore) {
        return world.getBlockType(x, y, z).getId().equals("Empty") || world.getBlockType(x, y, z).getId().equals(ore);
    }

    @Nullable
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }

    public static class LuckyMiningInfo {
        private String block;
        private double chance;
        private long lastBreak;

        public LuckyMiningInfo(String block, double chance, long lastBreak) {
            this.block = block;
            this.chance = chance;
            this.lastBreak = lastBreak;
        }
    }
}

