/*
 * Decompiled with CFR 0.152.
 */
package dev.smugtox.hidehelmet.net;

import com.hypixel.hytale.protocol.ComponentUpdate;
import com.hypixel.hytale.protocol.ComponentUpdateType;
import com.hypixel.hytale.protocol.EntityUpdate;
import com.hypixel.hytale.protocol.Equipment;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.packets.entities.EntityUpdates;
import com.hypixel.hytale.server.core.receiver.IPacketReceiver;
import dev.smugtox.hidehelmet.HideArmorState;
import java.util.UUID;
import javax.annotation.Nonnull;

public final class HideHelmetPacketReceiver
implements IPacketReceiver {
    private final IPacketReceiver delegate;
    private final UUID viewerUuid;
    private final int selfNetworkId;

    public HideHelmetPacketReceiver(IPacketReceiver delegate, UUID viewerUuid, int selfNetworkId) {
        this.delegate = delegate;
        this.viewerUuid = viewerUuid;
        this.selfNetworkId = selfNetworkId;
    }

    public void write(@Nonnull Packet packet) {
        this.delegate.write(this.maybeModify(packet));
    }

    public void writeNoCache(@Nonnull Packet packet) {
        this.delegate.writeNoCache(this.maybeModify(packet));
    }

    private Packet maybeModify(Packet packet) {
        int mask = HideArmorState.getMask(this.viewerUuid);
        if (mask == 0) {
            return packet;
        }
        if (!(packet instanceof EntityUpdates)) {
            return packet;
        }
        EntityUpdates eu = (EntityUpdates)packet;
        if (eu.updates == null || eu.updates.length == 0) {
            return packet;
        }
        boolean modified = false;
        EntityUpdate[] updatesCopy = null;
        for (int i = 0; i < eu.updates.length; ++i) {
            EntityUpdate upd = eu.updates[i];
            if (upd == null || upd.networkId != this.selfNetworkId || upd.updates == null || upd.updates.length == 0) continue;
            EntityUpdate updCopy = null;
            for (int j = 0; j < upd.updates.length; ++j) {
                int[] slots;
                String[] armorIds;
                ComponentUpdate cu = upd.updates[j];
                if (cu == null || cu.type != ComponentUpdateType.Equipment || cu.equipment == null || (armorIds = cu.equipment.armorIds) == null || armorIds.length == 0) continue;
                boolean shouldHide = false;
                for (int slot : slots = new int[]{0, 1, 2, 3}) {
                    if (!HideArmorState.isHidden(this.viewerUuid, slot) || slot < 0 || slot >= armorIds.length) continue;
                    shouldHide = true;
                    break;
                }
                if (!shouldHide) continue;
                if (!modified) {
                    updatesCopy = (EntityUpdate[])eu.updates.clone();
                    modified = true;
                }
                if (updCopy == null) {
                    updCopy = new EntityUpdate();
                    updCopy.networkId = upd.networkId;
                    updCopy.removed = upd.removed;
                    updCopy.updates = (ComponentUpdate[])upd.updates.clone();
                    updatesCopy[i] = updCopy;
                }
                ComponentUpdate cuCopy = new ComponentUpdate();
                cuCopy.type = cu.type;
                Equipment eqCopy = new Equipment();
                eqCopy.rightHandItemId = cu.equipment.rightHandItemId;
                eqCopy.leftHandItemId = cu.equipment.leftHandItemId;
                eqCopy.armorIds = (String[])armorIds.clone();
                for (int slot : slots) {
                    if (!HideArmorState.isHidden(this.viewerUuid, slot) || slot < 0 || slot >= eqCopy.armorIds.length) continue;
                    eqCopy.armorIds[slot] = "";
                }
                cuCopy.equipment = eqCopy;
                updCopy.updates[j] = cuCopy;
            }
        }
        if (!modified) {
            return packet;
        }
        EntityUpdates out = new EntityUpdates();
        out.removed = eu.removed;
        out.updates = updatesCopy;
        return out;
    }
}

