/*
 * Decompiled with CFR 0.152.
 */
package dev.smugtox.hidehelmet.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.smugtox.hidehelmet.HideArmorState;
import javax.annotation.Nonnull;

public class HideHelmetCommand
extends CommandBase {
    public HideHelmetCommand(String name, String description) {
        super(name, description);
    }

    protected void executeSync(@Nonnull CommandContext context) {
        CommandSender sender = context.sender();
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        HideArmorState.toggleSlot(player.getPlayerRef().getUuid(), 0);
        boolean enabled = HideArmorState.isHidden(player.getPlayerRef().getUuid(), 0);
        player.sendMessage(Message.raw((String)(enabled ? "HideHelmet: ON" : "HideHelmet: OFF")));
        this.forceRefresh(player);
    }

    private void forceRefresh(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        world.execute(() -> {
            try {
                player.invalidateEquipmentNetwork();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

