/*
 * Decompiled with CFR 0.152.
 */
package dev.smugtox.hidehelmet.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.smugtox.hidehelmet.HideArmorState;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class HideArmorCommand
extends CommandBase {
    public HideArmorCommand(String name, String description) {
        super(name, description);
        this.setAllowsExtraArguments(true);
    }

    protected void executeSync(@Nonnull CommandContext context) {
        CommandSender sender = context.sender();
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        String[] args = this.parseArgs(context, "hidearmor");
        if (args.length == 0) {
            this.sendHelp(player);
            this.sendStatus(player);
            return;
        }
        String first = args[0].toLowerCase();
        if ("status".equals(first)) {
            this.sendStatus(player);
            return;
        }
        if ("all".equals(first)) {
            int current = HideArmorState.getMask(player.getPlayerRef().getUuid());
            int newMask = HideArmorState.setAll(player.getPlayerRef().getUuid(), current != 15);
            player.sendMessage(Message.raw((String)("HideArmor: " + HideArmorState.formatMask(newMask))));
            this.forceRefresh(player);
            return;
        }
        if ("on".equals(first) || "off".equals(first)) {
            if (args.length < 2) {
                this.sendHelp(player);
                return;
            }
            boolean enable = "on".equals(first);
            String target = args[1].toLowerCase();
            if ("all".equals(target)) {
                int newMask = HideArmorState.setAll(player.getPlayerRef().getUuid(), enable);
                player.sendMessage(Message.raw((String)("HideArmor: " + HideArmorState.formatMask(newMask))));
                this.forceRefresh(player);
                return;
            }
            int slot = this.resolveSlot(target);
            if (slot < 0) {
                this.sendHelp(player);
                return;
            }
            int mask = HideArmorState.getMask(player.getPlayerRef().getUuid());
            int bit = 1 << slot;
            int newMask = enable ? mask | bit : mask & ~bit;
            HideArmorState.setMask(player.getPlayerRef().getUuid(), newMask);
            player.sendMessage(Message.raw((String)("HideArmor: " + HideArmorState.formatMask(newMask))));
            this.forceRefresh(player);
            return;
        }
        int slot = this.resolveSlot(first);
        if (slot >= 0) {
            int newMask = HideArmorState.toggleSlot(player.getPlayerRef().getUuid(), slot);
            player.sendMessage(Message.raw((String)("HideArmor: " + HideArmorState.formatMask(newMask))));
            this.forceRefresh(player);
            return;
        }
        this.sendHelp(player);
    }

    private void sendHelp(Player player) {
        player.sendMessage(Message.raw((String)"Usage: /hidearmor [status|all|on|off] [head|chest|hands|legs]"));
    }

    private void sendStatus(Player player) {
        int mask = HideArmorState.getMask(player.getPlayerRef().getUuid());
        player.sendMessage(Message.raw((String)("Hidden: " + HideArmorState.formatMask(mask))));
    }

    private int resolveSlot(String arg) {
        return switch (arg) {
            case "head" -> 0;
            case "chest" -> 1;
            case "hands" -> 2;
            case "legs" -> 3;
            default -> -1;
        };
    }

    private String[] parseArgs(CommandContext context, String commandName) {
        String input = context.getInputString();
        if (input == null) {
            return new String[0];
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            return new String[0];
        }
        String[] parts = trimmed.split("\\s+");
        if (parts.length == 0) {
            return new String[0];
        }
        String first = parts[0];
        if (first.startsWith("/")) {
            first = first.substring(1);
        }
        if (first.equalsIgnoreCase(commandName)) {
            return parts.length > 1 ? Arrays.copyOfRange(parts, 1, parts.length) : new String[]{};
        }
        return parts;
    }

    private void forceRefresh(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        world.execute(() -> {
            try {
                player.invalidateEquipmentNetwork();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

