/*
 * Decompiled with CFR 0.152.
 */
package dev.smugtox.hidehelmet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.entity.Entity;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.entity.LivingEntityInventoryChangeEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerCraftEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerInteractEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerMouseButtonEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.modules.entity.tracker.EntityTrackerSystems;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.smugtox.hidehelmet.HideArmorState;
import dev.smugtox.hidehelmet.commands.HideArmorCommand;
import dev.smugtox.hidehelmet.commands.HideHelmetCommand;
import dev.smugtox.hidehelmet.commands.HideHelmetDebugCommand;
import dev.smugtox.hidehelmet.net.HideHelmetPacketReceiver;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class HideHelmetPlugin
extends JavaPlugin {
    private static final int MAX_MASK = 15;
    private static final long DEFAULT_INVALIDATE_COOLDOWN_MS = 150L;
    private static final boolean DEFAULT_PICKUP_IMMEDIATE = true;
    private final Object saveLock = new Object();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private File dataFile;
    private ScheduledExecutorService saveExecutor;
    private ScheduledExecutorService invalidateExecutor;
    private ScheduledFuture<?> pendingSave;
    private boolean dirty;
    private long invalidateCooldownMs = 150L;
    private boolean pickupImmediate = true;
    private final Map<UUID, Long> lastInvalidateByPlayer = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, ScheduledFuture<?>> pendingInvalidates = new ConcurrentHashMap();

    public HideHelmetPlugin(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        this.initDataFile();
        int loadedCount = this.loadStateFromDisk();
        this.getLogger().at(Level.INFO).log("HideHelmet enabled (self-only). Loaded " + loadedCount + " players.");
        HideArmorState.setOnChange(this::markDirtyAndScheduleSave);
        this.initInvalidateScheduler();
        this.getCommandRegistry().registerCommand((AbstractCommand)new HideHelmetCommand("hidehelmet", "Toggle helmet visibility"));
        this.getCommandRegistry().registerCommand((AbstractCommand)new HideArmorCommand("hidearmor", "Toggle armor visibility"));
        this.getCommandRegistry().registerCommand((AbstractCommand)new HideHelmetDebugCommand("hhdebug", "Print armor slot indices"));
        this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, event -> {
            Player player = event.getPlayer();
            World world = player.getWorld();
            if (world == null) {
                return;
            }
            world.execute(() -> {
                try {
                    Store store = world.getEntityStore().getStore();
                    Ref ref = player.getReference();
                    EntityTrackerSystems.EntityViewer viewer = (EntityTrackerSystems.EntityViewer)store.getComponent(ref, EntityTrackerSystems.EntityViewer.getComponentType());
                    if (viewer == null || viewer.packetReceiver == null) {
                        return;
                    }
                    if (!(viewer.packetReceiver instanceof HideHelmetPacketReceiver)) {
                        viewer.packetReceiver = new HideHelmetPacketReceiver(viewer.packetReceiver, player.getPlayerRef().getUuid(), player.getNetworkId());
                    }
                    if (HideArmorState.getMask(player.getPlayerRef().getUuid()) != 0) {
                        try {
                            player.invalidateEquipmentNetwork();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        });
        this.getEventRegistry().registerGlobal(LivingEntityInventoryChangeEvent.class, event -> {
            Entity patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            this.requestEquipmentInvalidate(player, false);
        });
        this.getEventRegistry().registerGlobal(PlayerMouseButtonEvent.class, event -> {
            Player player = event.getPlayer();
            this.requestEquipmentInvalidate(player, false);
        });
        this.getEventRegistry().registerGlobal(PlayerCraftEvent.class, event -> {
            Player player = event.getPlayer();
            this.requestEquipmentInvalidate(player, false);
        });
        this.getEventRegistry().registerGlobal(PlayerInteractEvent.class, event -> {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            if (HideArmorState.getMask(player.getPlayerRef().getUuid()) == 0) {
                return;
            }
            InteractionType type = event.getActionType();
            if (type == null) {
                return;
            }
            if (type == InteractionType.Pickup) {
                this.requestEquipmentInvalidate(player, this.pickupImmediate);
            } else if (type == InteractionType.Primary || type == InteractionType.Secondary || type == InteractionType.Use || type == InteractionType.Pick || type == InteractionType.SwapTo || type == InteractionType.SwapFrom || type == InteractionType.Wielding || type == InteractionType.Equipped) {
                this.requestEquipmentInvalidate(player, false);
            }
        });
    }

    protected void shutdown() {
        int savedCount = this.saveStateToDisk();
        this.getLogger().at(Level.INFO).log("HideHelmet disabled. Saved " + savedCount + " players.");
        if (this.saveExecutor != null) {
            this.saveExecutor.shutdownNow();
        }
        if (this.invalidateExecutor != null) {
            this.invalidateExecutor.shutdownNow();
        }
    }

    private void initDataFile() {
        Path dataDir = this.getDataDirectory();
        if (dataDir == null) {
            return;
        }
        File dir = dataDir.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.dataFile = new File(dir, "players.json");
        if (!this.dataFile.exists()) {
            try {
                String seed = "{\"players\":{},\"config\":{\"invalidateCooldownMs\":150,\"pickupImmediate\":true}}";
                Files.writeString(this.dataFile.toPath(), (CharSequence)seed, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Exception e) {
                System.err.println("HideHelmet: Failed to create players.json: " + e.getMessage());
            }
        }
        this.saveExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "HideHelmet-Save");
            t.setDaemon(true);
            return t;
        });
    }

    private void initInvalidateScheduler() {
        this.invalidateExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "HideHelmet-Invalidate");
            t.setDaemon(true);
            return t;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyAndScheduleSave() {
        this.dirty = true;
        if (this.saveExecutor == null) {
            return;
        }
        Object object = this.saveLock;
        synchronized (object) {
            if (this.pendingSave == null || this.pendingSave.isDone()) {
                this.pendingSave = this.saveExecutor.schedule(this::saveStateToDisk, 1500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private int loadStateFromDisk() {
        if (this.dataFile == null || !this.dataFile.exists()) {
            return 0;
        }
        try {
            String json = Files.readString(this.dataFile.toPath(), StandardCharsets.UTF_8);
            SaveModel model = (SaveModel)this.gson.fromJson(json, SaveModel.class);
            if (model == null) {
                return 0;
            }
            if (model.config != null) {
                if (model.config.invalidateCooldownMs != null && model.config.invalidateCooldownMs > 0L) {
                    this.invalidateCooldownMs = model.config.invalidateCooldownMs;
                }
                if (model.config.pickupImmediate != null) {
                    this.pickupImmediate = model.config.pickupImmediate;
                }
            }
            if (model.players == null) {
                return 0;
            }
            int loaded = 0;
            for (Map.Entry<String, Integer> entry : model.players.entrySet()) {
                int clamped;
                Integer mask = entry.getValue();
                if (mask == null || (clamped = Math.max(0, Math.min(15, mask))) == 0) continue;
                try {
                    UUID uuid = UUID.fromString(entry.getKey());
                    HideArmorState.setMaskSilently(uuid, clamped);
                    ++loaded;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return loaded;
        }
        catch (Exception e) {
            System.err.println("HideHelmet: Failed to load state: " + e.getMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveStateToDisk() {
        if (this.dataFile == null) {
            return 0;
        }
        Object object = this.saveLock;
        synchronized (object) {
            if (!this.dirty) {
                return 0;
            }
            this.dirty = false;
        }
        try {
            Map<UUID, Integer> snapshot = HideArmorState.snapshot();
            HashMap<String, Integer> out = new HashMap<String, Integer>();
            for (Map.Entry<UUID, Integer> entry : snapshot.entrySet()) {
                int clamped;
                Integer mask = entry.getValue();
                if (mask == null || (clamped = Math.max(0, Math.min(15, mask))) == 0) continue;
                out.put(entry.getKey().toString(), clamped);
            }
            SaveModel model = new SaveModel();
            model.players = out;
            SaveConfig config = new SaveConfig();
            config.invalidateCooldownMs = this.invalidateCooldownMs;
            config.pickupImmediate = this.pickupImmediate;
            model.config = config;
            String json = this.gson.toJson((Object)model);
            Files.writeString(this.dataFile.toPath(), (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            return out.size();
        }
        catch (Exception e) {
            Object object2 = this.saveLock;
            synchronized (object2) {
                this.dirty = true;
            }
            System.err.println("HideHelmet: Failed to save state: " + e.getMessage());
            return 0;
        }
    }

    private void requestEquipmentInvalidate(Player player, boolean immediate) {
        if (player == null) {
            return;
        }
        if (HideArmorState.getMask(player.getPlayerRef().getUuid()) == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        if (immediate) {
            this.cancelPendingInvalidate(player.getPlayerRef().getUuid());
            this.lastInvalidateByPlayer.put(player.getPlayerRef().getUuid(), now);
            this.executeInvalidate(player);
            return;
        }
        Long last = this.lastInvalidateByPlayer.get(player.getPlayerRef().getUuid());
        if (last == null || now - last >= this.invalidateCooldownMs) {
            this.lastInvalidateByPlayer.put(player.getPlayerRef().getUuid(), now);
            this.executeInvalidate(player);
            return;
        }
        long delay = this.invalidateCooldownMs - (now - last);
        this.scheduleDeferredInvalidate(player, delay);
    }

    private void scheduleDeferredInvalidate(Player player, long delayMs) {
        if (this.invalidateExecutor == null) {
            return;
        }
        UUID uuid = player.getPlayerRef().getUuid();
        this.pendingInvalidates.compute(uuid, (key, existing) -> {
            if (existing != null && !existing.isDone()) {
                return existing;
            }
            return this.invalidateExecutor.schedule(() -> {
                try {
                    this.executeInvalidate(player);
                }
                finally {
                    this.pendingInvalidates.remove(key);
                    this.lastInvalidateByPlayer.put((UUID)key, System.currentTimeMillis());
                }
            }, Math.max(0L, delayMs), TimeUnit.MILLISECONDS);
        });
    }

    private void cancelPendingInvalidate(UUID uuid) {
        ScheduledFuture<?> pending = this.pendingInvalidates.remove(uuid);
        if (pending != null) {
            pending.cancel(false);
        }
    }

    private void executeInvalidate(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        world.execute(() -> {
            try {
                player.invalidateEquipmentNetwork();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static final class SaveModel {
        Map<String, Integer> players = new HashMap<String, Integer>();
        SaveConfig config;

        private SaveModel() {
        }
    }

    private static final class SaveConfig {
        Long invalidateCooldownMs;
        Boolean pickupImmediate;

        private SaveConfig() {
        }
    }
}

