/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.util;

import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.universe.world.World;
import com.natamus.hybrid.functions.VectorFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Util {
    public static void fillTreeRootsHole(World world, Set<Vector3i> lowestPositions, String saplingBlockId) {
        HashSet<Object> holePositions = new HashSet<Object>();
        String soilBlockId = "";
        block0: for (Vector3i lowestPos : lowestPositions) {
            for (int i = 0; i < 10; ++i) {
                Vector3i possibleHolePos = new Vector3i(lowestPos.x, lowestPos.y + i, lowestPos.z);
                ArrayList<Vector3i> airNeighbours = new ArrayList<Vector3i>();
                for (Vector3i neighbourPos : VectorFunctions.getSameLevel3x3((Vector3i)possibleHolePos)) {
                    BlockType neighbourBlockType = world.getBlockType(neighbourPos);
                    if (neighbourBlockType == null) continue;
                    String neighbourBlockId = neighbourBlockType.getId();
                    if (neighbourBlockId == null) {
                        neighbourBlockId = "Empty";
                    }
                    if (neighbourBlockId.equals("Empty") || neighbourBlockId.contains("Plant_")) {
                        airNeighbours.add(neighbourPos.clone());
                        continue;
                    }
                    if (!soilBlockId.isEmpty() || !neighbourBlockId.startsWith("Soil_")) continue;
                    soilBlockId = neighbourBlockId;
                }
                if (airNeighbours.size() > 5) continue block0;
                holePositions.add(possibleHolePos);
                holePositions.addAll(airNeighbours);
            }
        }
        if (soilBlockId.isEmpty()) {
            soilBlockId = "Soil_Dirt";
        }
        Vector3i highestHolePos = Vector3i.MIN;
        for (Vector3i vector3i : holePositions) {
            world.setBlock(vector3i.x, vector3i.y, vector3i.z, soilBlockId);
            if (vector3i.y <= highestHolePos.y) continue;
            highestHolePos = vector3i.clone();
        }
        if (ConfigHandler.getConfigHandler().plantSaplingAfterHarvestIfFound) {
            Util.plantSapling(world, highestHolePos, saplingBlockId);
        }
    }

    public static void plantSapling(World world, Vector3i highestHolePos, String saplingBlockId) {
        if (saplingBlockId.isEmpty()) {
            return;
        }
        world.setBlock(highestHolePos.x, highestHolePos.y + 1, highestHolePos.z, saplingBlockId);
    }
}

