/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.event;

import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.World;
import com.natamus.hybrid.data.HybridConstants;
import com.natamus.hybrid.event.callback.EntityBreakBlockCallback;
import com.natamus.hybrid.functions.BlockFunctions;
import com.natamus.hybrid.functions.ItemStackFunctions;
import com.natamus.hybrid.functions.PlayerFunctions;
import com.natamus.hybrid.functions.ToolFunctions;
import com.natamus.hybrid.functions.VectorFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import com.natamus.treeharvester.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class EntityCallbacks {
    public static void init() {
        EntityBreakBlockCallback.ENTITY_BREAK_BLOCK.register(EntityCallbacks::onBlockBreakEvent);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean onBlockBreakEvent(Player player, BlockType blockType, Vector3i targetBlockPos, ItemStack handStack) {
        void var15_19;
        if (!ConfigHandler.getConfigHandler().enableTreeHarvester) {
            return true;
        }
        World world = player.getWorld();
        if (world == null) {
            return true;
        }
        if (ConfigHandler.getConfigHandler().playerMustCrouch && !PlayerFunctions.isCrouching((Player)player)) {
            return true;
        }
        if (!BlockFunctions.isLog((BlockType)blockType)) {
            return true;
        }
        if (ConfigHandler.getConfigHandler().mustHoldHatchet && !ToolFunctions.isHatchet((ItemStack)handStack)) {
            return true;
        }
        String fuzzyTreeBlockId = blockType.getId().split("_")[1];
        List connectedTreePositions = VectorFunctions.getTreeBlockPositions((World)world, (Vector3i)targetBlockPos, (String)("_" + fuzzyTreeBlockId), (boolean)false, (boolean)true);
        if (connectedTreePositions.isEmpty()) {
            return true;
        }
        HashSet<Object> treeLeaves = new HashSet<Object>();
        HashSet<Object> treeBranches = new HashSet<Object>();
        HashSet<Object> treeLogs = new HashSet<Object>();
        boolean allowBrokenHatchet = ConfigHandler.getConfigHandler().allowBrokenHatchet;
        boolean dropLogsAtFirstBrokenBlock = ConfigHandler.getConfigHandler().dropLogsAtFirstBrokenBlock;
        boolean decreaseDurability = ConfigHandler.getConfigHandler().decreaseDurabilityPerHarvestedLog;
        for (Object treePos : connectedTreePositions) {
            if (!allowBrokenHatchet && Objects.requireNonNull(player.getInventory().getItemInHand()).isBroken()) break;
            BlockType blockType2 = world.getBlockType((Vector3i)treePos);
            if (blockType2 == null) continue;
            if (BlockFunctions.isBranch((BlockType)blockType2)) {
                treeBranches.add(treePos);
                continue;
            }
            if (BlockFunctions.isLeavesBlock((BlockType)blockType2)) {
                treeLeaves.add(treePos);
                continue;
            }
            if (!BlockFunctions.isLog((BlockType)blockType2, (boolean)false)) continue;
            treeLogs.add(treePos);
        }
        if (treeBranches.size() < 5 || treeLeaves.size() < 5) {
            return true;
        }
        HashMap<Long, Vector3i> lowestByXZ = new HashMap<Long, Vector3i>();
        for (Vector3i vector3i : treeLogs) {
            long key;
            Vector3i existing;
            if (dropLogsAtFirstBrokenBlock) {
                BlockFunctions.dropBlock((World)world, (Vector3i)vector3i, (Vector3i)targetBlockPos, (boolean)true, (int)128);
            } else {
                BlockFunctions.dropBlock((World)world, (Vector3i)vector3i, (Vector3i)vector3i, (boolean)true, (int)128);
            }
            if (decreaseDurability) {
                PlayerFunctions.decreaseHeldItemDurability((Player)player, (World)world, (double)ConfigHandler.getConfigHandler().durabilityPerHarvestedLog, (boolean)false);
            }
            if ((existing = (Vector3i)lowestByXZ.get(key = (long)vector3i.x << 32 | (long)vector3i.z & 0xFFFFFFFFL)) != null && vector3i.y >= existing.y) continue;
            lowestByXZ.put(key, vector3i.clone());
        }
        HashSet lowestPositions = new HashSet(lowestByXZ.values());
        ItemStack itemStack = ItemStack.EMPTY;
        Object saplingBlockId = "Plant_Sapling_" + fuzzyTreeBlockId;
        if (!HybridConstants.ITEMS.containsKey(saplingBlockId)) {
            saplingBlockId = "";
        }
        boolean dropTreeLeaves = ConfigHandler.getConfigHandler().dropTreeLeaves;
        boolean addSaplingDropChanceFromLeaves = ConfigHandler.getConfigHandler().addSaplingDropChanceFromLeaves;
        double saplingDropChance = ConfigHandler.getConfigHandler().saplingDropChance;
        for (Vector3i vector3i : treeLeaves) {
            if (dropTreeLeaves) {
                if (dropLogsAtFirstBrokenBlock) {
                    BlockFunctions.dropBlock((World)world, (Vector3i)vector3i, (Vector3i)targetBlockPos, (boolean)true, (int)128);
                } else {
                    BlockFunctions.dropBlock((World)world, (Vector3i)vector3i, (Vector3i)vector3i, (boolean)true, (int)128);
                }
            }
            if (!addSaplingDropChanceFromLeaves || !(HybridConstants.RANDOM.nextDouble() < saplingDropChance) || ((String)saplingBlockId).isEmpty()) continue;
            if (var15_19 == null || var15_19.isEmpty()) {
                ItemStack itemStack2 = new ItemStack((String)saplingBlockId, 1);
                continue;
            }
            ItemStack itemStack3 = var15_19.withQuantity(var15_19.getQuantity() + 1);
        }
        if (addSaplingDropChanceFromLeaves && var15_19 != null && !var15_19.isEmpty()) {
            ItemStackFunctions.dropItemStack((World)world, (ItemStack)var15_19, (Vector3i)targetBlockPos);
        }
        BlockFunctions.dropBlock((World)world, (Vector3i)targetBlockPos, (boolean)true);
        for (Vector3i vector3i : connectedTreePositions) {
            world.performBlockUpdate(vector3i.x, vector3i.y, vector3i.z);
        }
        if (ConfigHandler.getConfigHandler().fillTreeRootsHole && !lowestPositions.isEmpty()) {
            Object finalSaplingBlockId = saplingBlockId;
            world.execute(() -> EntityCallbacks.lambda$onBlockBreakEvent$0(world, lowestPositions, (String)finalSaplingBlockId));
        }
        return false;
    }

    private static /* synthetic */ void lambda$onBlockBreakEvent$0(World world, Set lowestPositions, String finalSaplingBlockId) {
        Util.fillTreeRootsHole(world, lowestPositions, finalSaplingBlockId);
    }
}

