/*
 * Decompiled with CFR 0.152.
 */
package com.linceros.grabfromfar;

import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.asset.type.gameplay.CraftingConfig;
import com.hypixel.hytale.server.core.asset.type.gameplay.GameplayConfig;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nonnull;

public class GrabFromFarPlugin
extends JavaPlugin {
    private int horizontalRadius = 16;
    private int verticalRadius = 8;
    private int chestLimit = 200;

    public GrabFromFarPlugin(@Nonnull JavaPluginInit javaPluginInit) {
        super(javaPluginInit);
    }

    protected void setup() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Iniciando...");
        this.loadConfig();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Configuraci\u00f3n:");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Radio horizontal: " + this.horizontalRadius + " bloques");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Radio vertical: " + this.verticalRadius + " bloques");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   L\u00edmite de cofres: " + this.chestLimit);
    }

    protected void start() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Aplicando configuraci\u00f3n...");
        try {
            this.applyExtendedRadius();
        }
        catch (Exception exception) {
            ((HytaleLogger.Api)this.getLogger().atSevere()).log("[GrabFromFar] Error cr\u00edtico: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void shutdown() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Plugin desactivado.");
    }

    private void applyExtendedRadius() throws Exception {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Buscando GameplayConfig.getAssetMap()...");
        DefaultAssetMap defaultAssetMap = GameplayConfig.getAssetMap();
        if (defaultAssetMap == null) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[GrabFromFar] AssetMap es null");
            return;
        }
        GameplayConfig gameplayConfig = (GameplayConfig)defaultAssetMap.getAsset((Object)"Default");
        if (gameplayConfig == null) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[GrabFromFar] GameplayConfig 'Default' no encontrado");
            return;
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] GameplayConfig encontrado!");
        CraftingConfig craftingConfig = gameplayConfig.getCraftingConfig();
        if (craftingConfig == null) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[GrabFromFar] CraftingConfig es null");
            return;
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] CraftingConfig encontrado!");
        int n = craftingConfig.getBenchMaterialHorizontalChestSearchRadius();
        int n2 = craftingConfig.getBenchMaterialVerticalChestSearchRadius();
        int n3 = craftingConfig.getBenchMaterialChestLimit();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Valores actuales:");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Horizontal: " + n);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Vertical: " + n2);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   L\u00edmite: " + n3);
        Class<CraftingConfig> clazz = CraftingConfig.class;
        Field field = clazz.getDeclaredField("benchMaterialHorizontalChestSearchRadius");
        Field field2 = clazz.getDeclaredField("benchMaterialVerticalChestSearchRadius");
        Field field3 = clazz.getDeclaredField("benchMaterialChestLimit");
        field.setAccessible(true);
        field2.setAccessible(true);
        field3.setAccessible(true);
        field.setInt(craftingConfig, this.horizontalRadius);
        field2.setInt(craftingConfig, this.verticalRadius);
        field3.setInt(craftingConfig, this.chestLimit);
        int n4 = craftingConfig.getBenchMaterialHorizontalChestSearchRadius();
        int n5 = craftingConfig.getBenchMaterialVerticalChestSearchRadius();
        int n6 = craftingConfig.getBenchMaterialChestLimit();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] \u00a1Valores aplicados exitosamente!");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Nuevos valores:");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Horizontal: " + n + " -> " + n4);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   Vertical: " + n2 + " -> " + n5);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar]   L\u00edmite: " + n3 + " -> " + n6);
    }

    private void loadConfig() {
        try {
            Path path = this.getDataDirectory().resolve("config.txt");
            if (Files.exists(path, new LinkOption[0])) {
                List<String> list = Files.readAllLines(path);
                for (String string : list) {
                    String[] stringArray;
                    if ((string = string.trim()).startsWith("#") || string.isEmpty() || (stringArray = string.split("=")).length != 2) continue;
                    String string2 = stringArray[0].trim();
                    int n = Integer.parseInt(stringArray[1].trim());
                    switch (string2) {
                        case "horizontalRadius": {
                            this.horizontalRadius = n;
                            break;
                        }
                        case "verticalRadius": {
                            this.verticalRadius = n;
                            break;
                        }
                        case "chestLimit": {
                            this.chestLimit = n;
                        }
                    }
                }
                ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Configuraci\u00f3n cargada desde config.txt");
            } else {
                this.saveDefaultConfig(path);
            }
        }
        catch (Exception exception) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[GrabFromFar] Error cargando config: " + exception.getMessage());
        }
    }

    private void saveDefaultConfig(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String string = "# Grab From Far - Configuraci\u00f3n\n# Por Linceros\n#\n# Radio de b\u00fasqueda de cofres al craftear\n# Valores por defecto del juego: horizontal=7, vertical=3, limit=100\n# \u00a1Este mod salta la validaci\u00f3n, puedes poner valores m\u00e1s altos!\n\nhorizontalRadius=16\nverticalRadius=8\nchestLimit=200\n";
            Files.writeString(path, (CharSequence)string, new OpenOption[0]);
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("[GrabFromFar] Archivo config.txt creado");
        }
        catch (Exception exception) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[GrabFromFar] No se pudo crear config.txt");
        }
    }
}

