/*
 * Decompiled with CFR 0.152.
 */
package games.player.home.commands;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.modules.entity.component.HeadRotation;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import games.player.home.HomeManager;
import java.util.UUID;
import javax.annotation.Nonnull;

public class SetHomeCommand
extends AbstractPlayerCommand {
    private final HomeManager homeManager;

    public SetHomeCommand(@Nonnull HomeManager homeManager) {
        super("sethome", "Set your home location");
        this.homeManager = homeManager;
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (transform == null) {
            context.sendMessage(Message.raw((String)"Could not get your position."));
            return;
        }
        HeadRotation headRotation = (HeadRotation)store.getComponent(ref, HeadRotation.getComponentType());
        Vector3f rotation = headRotation != null ? headRotation.getRotation() : new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3d position = transform.getPosition();
        UUID playerUuid = playerRef.getUuid();
        this.homeManager.setHome(playerUuid, world, position, rotation);
        context.sendMessage(Message.raw((String)String.format("Home set at %.1f, %.1f, %.1f in %s", position.getX(), position.getY(), position.getZ(), world.getName())));
    }
}

