/*
 * Decompiled with CFR 0.152.
 */
package games.player.home;

import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import games.player.home.HomeManager;
import games.player.home.commands.HomeCommand;
import games.player.home.commands.SetHomeCommand;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class HomePlugin
extends JavaPlugin {
    private HomeManager homeManager;

    public HomePlugin(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        this.getLogger().at(Level.INFO).log("Home plugin is setting up...");
        this.homeManager = new HomeManager(this.getDataDirectory(), this.getLogger());
    }

    protected void start() {
        this.getLogger().at(Level.INFO).log("Home plugin is starting!");
        this.getCommandRegistry().registerCommand((AbstractCommand)new SetHomeCommand(this.homeManager));
        this.getCommandRegistry().registerCommand((AbstractCommand)new HomeCommand(this.homeManager));
        this.getLogger().at(Level.INFO).log("Home plugin started successfully!");
        this.getLogger().at(Level.INFO).log("Commands registered: /home, /sethome");
    }

    protected void shutdown() {
        this.getLogger().at(Level.INFO).log("Home plugin is shutting down...");
        if (this.homeManager != null) {
            this.homeManager.save();
            this.getLogger().at(Level.INFO).log("Total homes saved: %d", this.homeManager.getHomeCount());
        }
    }
}

