/*
 * Decompiled with CFR 0.152.
 */
package games.player.home;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.universe.world.World;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HomeManager {
    private static final String HOMES_FILE = "homes.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type HOMES_TYPE = new TypeToken<Map<String, HomeLocation>>(){}.getType();
    private final Path dataDirectory;
    private final HytaleLogger logger;
    private final Map<UUID, HomeLocation> homes = new ConcurrentHashMap<UUID, HomeLocation>();

    public HomeManager(@Nonnull Path dataDirectory, @Nonnull HytaleLogger logger) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.load();
    }

    private void load() {
        Path homesFile = this.dataDirectory.resolve(HOMES_FILE);
        if (!Files.exists(homesFile, new LinkOption[0])) {
            ((HytaleLogger.Api)this.logger.atInfo()).log("No existing homes file found, starting fresh.");
            return;
        }
        try {
            String json = Files.readString(homesFile);
            Map loaded = (Map)GSON.fromJson(json, HOMES_TYPE);
            if (loaded != null) {
                for (Map.Entry entry : loaded.entrySet()) {
                    try {
                        UUID uuid = UUID.fromString((String)entry.getKey());
                        this.homes.put(uuid, (HomeLocation)entry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        ((HytaleLogger.Api)this.logger.atWarning()).log("Invalid UUID in homes file: %s", entry.getKey());
                    }
                }
                ((HytaleLogger.Api)this.logger.atInfo()).log("Loaded %d homes from disk.", this.homes.size());
            }
        }
        catch (IOException e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("Failed to load homes from disk: %s", (Object)e.getMessage());
        }
    }

    public void save() {
        try {
            if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            ConcurrentHashMap<String, HomeLocation> toSave = new ConcurrentHashMap<String, HomeLocation>();
            for (Map.Entry<UUID, HomeLocation> entry : this.homes.entrySet()) {
                toSave.put(entry.getKey().toString(), entry.getValue());
            }
            Path homesFile = this.dataDirectory.resolve(HOMES_FILE);
            String json = GSON.toJson(toSave, HOMES_TYPE);
            Files.writeString(homesFile, (CharSequence)json, new OpenOption[0]);
            ((HytaleLogger.Api)this.logger.atFine()).log("Saved %d homes to disk.", this.homes.size());
        }
        catch (IOException e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("Failed to save homes to disk: %s", (Object)e.getMessage());
        }
    }

    public void setHome(@Nonnull UUID playerUuid, @Nonnull World world, @Nonnull Vector3d position, @Nonnull Vector3f rotation) {
        HomeLocation home = new HomeLocation(world.getName(), position.getX(), position.getY(), position.getZ(), rotation.getYaw(), rotation.getPitch());
        this.homes.put(playerUuid, home);
        this.save();
    }

    @Nullable
    public HomeLocation getHome(@Nonnull UUID playerUuid) {
        return this.homes.get(playerUuid);
    }

    public boolean hasHome(@Nonnull UUID playerUuid) {
        return this.homes.containsKey(playerUuid);
    }

    public void removeHome(@Nonnull UUID playerUuid) {
        this.homes.remove(playerUuid);
        this.save();
    }

    public int getHomeCount() {
        return this.homes.size();
    }

    public record HomeLocation(@Nonnull String worldName, double x, double y, double z, float yaw, float pitch) {
        public Vector3d toPosition() {
            return new Vector3d(this.x, this.y, this.z);
        }

        public Vector3f toRotation() {
            return new Vector3f(this.yaw, this.pitch, 0.0f);
        }
    }
}

