/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.overstacked;

import com.hypixel.hytale.assetstore.event.LoadedAssetsEvent;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.util.Config;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.darkhax.overstacked.MaxStackSizeConfig;

public class Overstacked
extends JavaPlugin {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private final Config<MaxStackSizeConfig> cfg = this.withConfig("MaxStackSizes", MaxStackSizeConfig.CODEC);

    public Overstacked(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        this.getEventRegistry().register(LoadedAssetsEvent.class, Item.class, this::onItemAssetLoad);
        this.cfg.save();
    }

    private void onItemAssetLoad(@Nonnull LoadedAssetsEvent<String, Item, DefaultAssetMap<String, Item>> event) {
        try {
            Map assets = event.getLoadedAssets();
            Field maxStackSize = Item.class.getDeclaredField("maxStack");
            maxStackSize.setAccessible(true);
            for (Map.Entry<String, Integer> entry : ((MaxStackSizeConfig)this.cfg.get()).itemIds.entrySet()) {
                Item item = (Item)assets.get(entry.getKey());
                if (item == null) continue;
                maxStackSize.set(item, entry.getValue());
            }
            for (Map.Entry<String, Integer> entry : ((MaxStackSizeConfig)this.cfg.get()).patterns.entrySet()) {
                Pattern pattern = Pattern.compile(entry.getKey());
                for (String id : assets.keySet()) {
                    if (!pattern.matcher(id).matches()) continue;
                    maxStackSize.set(assets.get(id), entry.getValue());
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

