/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eyespy.impl.info;

import com.hypixel.hytale.builtin.crafting.state.BenchState;
import com.hypixel.hytale.builtin.crafting.state.ProcessingBenchState;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.asset.type.item.config.ItemTranslationProperties;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.jarhax.eyespy.EyeSpy;
import com.jarhax.eyespy.api.MessageHelpers;
import com.jarhax.eyespy.api.context.BlockContext;
import com.jarhax.eyespy.api.info.InfoBuilder;
import com.jarhax.eyespy.api.info.InfoProvider;
import com.jarhax.eyespy.api.info.InfoValue;
import com.jarhax.eyespy.api.info.values.GroupValue;
import com.jarhax.eyespy.api.info.values.IconValue;
import com.jarhax.eyespy.api.info.values.ItemGridValue;
import com.jarhax.eyespy.api.info.values.LabelValue;
import com.jarhax.eyespy.api.info.values.ProgressBarValue;
import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VanillaBlockInfoProvider
implements InfoProvider<BlockContext> {
    private static final Color color = new Color(85, 85, 255);
    private static final Color color2 = new Color(170, 170, 170);

    @Override
    public void updateDescription(BlockContext context, InfoBuilder infoBuilder) {
        if (!context.getBlock().getId().equals("Empty")) {
            String owner;
            infoBuilder.set("Header", s -> new LabelValue((String)s, VanillaBlockInfoProvider.getDisplayName(context.getBlock()), 24));
            Item item = context.getBlock().getItem();
            if (item != null) {
                infoBuilder.setIcon(new IconValue(item.getId()));
            }
            if (context.getState() != null) {
                infoBuilder.set("Body", s -> {
                    BlockState blockState = context.getState();
                    Objects.requireNonNull(blockState);
                    BlockState selector0$temp = blockState;
                    int index$1 = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProcessingBenchState.class, BenchState.class, ItemContainerState.class}, (BlockState)selector0$temp, index$1)) {
                        case 0 -> {
                            ProcessingBenchState processor = (ProcessingBenchState)selector0$temp;
                            ArrayList<InfoValue> values = new ArrayList<InfoValue>();
                            values.add(new LabelValue(s + "Tier", MessageHelpers.tier(processor.getTierLevel()).color(color2)));
                            if (processor.isActive() && processor.getRecipe() != null && !Float.isNaN(processor.getInputProgress()) && !Float.isNaN(processor.getRecipe().getTimeSeconds())) {
                                float value = processor.getInputProgress() / processor.getRecipe().getTimeSeconds();
                                values.add(new ProgressBarValue(s + "Progress", (float)Math.round(value * 1000.0f) / 1000.0f));
                            }
                            yield new GroupValue((String)s, (List<InfoValue>)values);
                        }
                        case 1 -> {
                            BenchState bench = (BenchState)selector0$temp;
                            yield new LabelValue((String)s, MessageHelpers.tier(bench.getTierLevel()).color(color2));
                        }
                        case 2 -> {
                            ItemContainerState container = (ItemContainerState)selector0$temp;
                            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                            block5: for (short i = 0; i < container.getItemContainer().getCapacity(); i = (short)(i + 1)) {
                                ItemStack stack = container.getItemContainer().getItemStack(i);
                                if (stack == null) continue;
                                for (int j = 0; j < stacks.size(); ++j) {
                                    ItemStack itemStack = (ItemStack)stacks.get(j);
                                    if (!itemStack.isEquivalentType(stack)) continue;
                                    stacks.set(j, itemStack.withQuantity(itemStack.getQuantity() + stack.getQuantity()));
                                    continue block5;
                                }
                                ItemStack safeStack = stack.withMetadata(null).withDurability(stack.getMaxDurability() > 0.0 ? Math.max(1.0, stack.getDurability()) : stack.getDurability());
                                stacks.add(safeStack);
                            }
                            yield new ItemGridValue((String)s, (List<ItemStack>)stacks);
                        }
                        default -> InfoValue.EMPTY;
                    };
                });
            }
            if ((owner = EyeSpy.OWNERSHIP.get(context.getBlock().getId())) != null) {
                infoBuilder.set("Footer", s -> new LabelValue((String)s, Message.raw((String)owner).color(color).bold(true)));
            }
        }
    }

    private static Message getDisplayName(BlockType type) {
        String nameKey;
        ItemTranslationProperties translations;
        Item item = type.getItem();
        if (item != null && (translations = item.getTranslationProperties()) != null && (nameKey = translations.getName()) != null) {
            return Message.translation((String)nameKey);
        }
        return Message.raw((String)type.getId());
    }
}

