/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eyespy.impl.hud;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.jarhax.eyespy.api.context.BlockContext;
import com.jarhax.eyespy.api.context.Context;
import com.jarhax.eyespy.api.context.EntityContext;
import com.jarhax.eyespy.api.info.AnchorBuilder;
import com.jarhax.eyespy.api.info.InfoBuilder;
import com.jarhax.eyespy.api.info.InfoProvider;
import com.jarhax.eyespy.api.info.InfoValue;
import com.jarhax.eyespy.impl.info.VanillaBlockInfoProvider;
import com.jarhax.eyespy.impl.info.VanillaEntityInfoProvider;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EyeSpyHud
extends CustomUIHud {
    private static final List<InfoProvider<BlockContext>> blockInfoProviders = new LinkedList<InfoProvider<BlockContext>>();
    private static final List<InfoProvider<EntityContext>> entityInfoProviders = new LinkedList<InfoProvider<EntityContext>>();
    @Nullable
    private InfoBuilder info;
    @Nullable
    private BlockContext blockContext;
    @Nullable
    private EntityContext entityContext;

    public EyeSpyHud(@Nonnull PlayerRef playerRef) {
        super(playerRef);
    }

    public void updateHud(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        block2: {
            Player player;
            block3: {
                this.info = new InfoBuilder();
                Holder holder = EntityUtils.toHolder((int)index, archetypeChunk);
                player = (Player)holder.getComponent(Player.getComponentType());
                if (player == null || player.getWorld() == null) break block2;
                this.entityContext = EntityContext.create(player, dt, index, archetypeChunk, store, commandBuffer);
                if (this.entityContext == null) break block3;
                for (InfoProvider<EntityContext> provider : entityInfoProviders) {
                    provider.updateDescription(this.entityContext, this.info);
                }
                break block2;
            }
            this.blockContext = BlockContext.create(player, dt, index, archetypeChunk, store, commandBuffer);
            if (this.blockContext == null) break block2;
            for (InfoProvider<BlockContext> provider : blockInfoProviders) {
                provider.updateDescription(this.blockContext, this.info);
            }
        }
    }

    protected void build(@Nonnull UICommandBuilder ui) {
        block4: {
            block3: {
                if (this.info != null && this.info.canDisplay()) {
                    ui.append("Hud/EyeSpy/EyeSpy.ui");
                    AnchorBuilder anchorBuilder = new AnchorBuilder().setTop(20).setLeft(20);
                    this.info.values().filter(infoValue -> infoValue != InfoValue.EMPTY).forEach(infoValue -> infoValue.build(ui, anchorBuilder, "#Info"));
                    this.info.getIcon().build(ui, anchorBuilder, "#IconContainer");
                    ui.setObject("#EyeSpyHud.Anchor", (Object)anchorBuilder.build());
                }
                if (this.entityContext == null) break block3;
                for (InfoProvider<Context> infoProvider : entityInfoProviders) {
                    infoProvider.modifyUI(this.entityContext, ui);
                }
                break block4;
            }
            if (this.blockContext == null) break block4;
            for (InfoProvider<Context> infoProvider : blockInfoProviders) {
                infoProvider.modifyUI(this.blockContext, ui);
            }
        }
    }

    static {
        blockInfoProviders.add(new VanillaBlockInfoProvider());
        entityInfoProviders.add(new VanillaEntityInfoProvider());
    }
}

