/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eyespy.api.context;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.BlockPosition;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.TargetUtil;
import com.jarhax.eyespy.api.context.Context;
import javax.annotation.Nullable;

public class BlockContext
extends Context {
    private final BlockType block;
    private final BlockState state;
    private final Vector3i targetPos;
    private final Vector3i offsetPos;

    public BlockContext(float delta, int index, ArchetypeChunk<EntityStore> archetypeChunk, Store<EntityStore> store, CommandBuffer<EntityStore> commandBuffer, Player observer, WorldChunk chunk, Vector3i targetPos, Vector3i offsetPos, BlockType block, BlockState state) {
        super(delta, index, archetypeChunk, store, commandBuffer, observer, chunk);
        this.targetPos = targetPos;
        this.offsetPos = offsetPos;
        this.block = block;
        this.state = state;
    }

    public BlockType getBlock() {
        return this.block;
    }

    @Nullable
    public BlockState getState() {
        return this.state;
    }

    public Vector3i getTargetPos() {
        return this.targetPos;
    }

    public Vector3i getOffsetPos() {
        return this.offsetPos;
    }

    @Nullable
    public static BlockContext create(Player player, float dt, int index, ArchetypeChunk<EntityStore> archetypeChunk, Store<EntityStore> store, CommandBuffer<EntityStore> commandBuffer) {
        Vector3i targetBlockPos;
        WorldChunk chunk;
        TransformComponent transform = (TransformComponent)archetypeChunk.getComponent(index, TransformComponent.getComponentType());
        if (transform != null && (chunk = transform.getChunk()) != null && (targetBlockPos = TargetUtil.getTargetBlock((Ref)archetypeChunk.getReferenceTo(index), (double)5.0, commandBuffer)) != null) {
            BlockPosition pos = player.getWorld().getBaseBlock(new BlockPosition(targetBlockPos.x, targetBlockPos.y, targetBlockPos.z));
            BlockType block = chunk.getBlockType(pos.x, pos.y, pos.z);
            BlockState state = chunk.getState(pos.x, pos.y, pos.z);
            return new BlockContext(dt, index, archetypeChunk, store, commandBuffer, player, chunk, targetBlockPos, new Vector3i(pos.x, pos.y, pos.z), block, state);
        }
        return null;
    }
}

