/*
 * Decompiled with CFR 0.152.
 */
package net.night.recoverarrows;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.RemoveReason;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.spatial.SpatialResource;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackTransaction;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.ModelComponent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.physics.component.Velocity;
import com.hypixel.hytale.server.core.modules.projectile.component.Projectile;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BowArrowMagnetSystem
extends EntityTickingSystem<EntityStore> {
    @Nonnull
    private final Query<EntityStore> query;
    private static final double HORIZONTAL_RANGE = 3.0;
    private static final double RANGE_DOWN_FROM_FEET = 1.5;
    private static final double RANGE_UP_FROM_FEET = 3.0;
    private static final double SEARCH_RADIUS = 12.0;
    private static final double MIN_VELOCITY = 0.05;
    private static final int MESSAGE_COOLDOWN = 20;
    private static final int MIN_ALIVE_TICKS = 5;
    private final HashMap<UUID, Integer> lastMessageTick = new HashMap();
    private final HashMap<Integer, ArrowTracker> trackedArrows = new HashMap();
    private static final HashMap<UUID, String> lastArrowEquipped = new HashMap();
    private int currentTick = 0;

    public BowArrowMagnetSystem() {
        this.query = Query.and((Query[])new Query[]{Player.getComponentType()});
    }

    public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        ++this.currentTick;
        Ref playerRef = archetypeChunk.getReferenceTo(index);
        Player player = (Player)EntityUtils.toHolder((int)index, archetypeChunk).getComponent(Player.getComponentType());
        if (player == null) {
            return;
        }
        PlayerRef playerRefComponent = (PlayerRef)commandBuffer.getComponent(playerRef, PlayerRef.getComponentType());
        if (playerRefComponent == null) {
            return;
        }
        UUID playerUUID = playerRefComponent.getUuid();
        TransformComponent playerTransform = (TransformComponent)commandBuffer.getComponent(playerRef, TransformComponent.getComponentType());
        ModelComponent playerModel = (ModelComponent)commandBuffer.getComponent(playerRef, ModelComponent.getComponentType());
        if (playerTransform == null || playerModel == null) {
            return;
        }
        this.detectBowAndArrow(player, playerUUID);
        Vector3d playerPos = playerTransform.getPosition().clone();
        double eyeHeight = playerModel.getModel().getEyeHeight();
        ArrayList<ArrowToCollect> arrowsToCollect = new ArrayList<ArrowToCollect>();
        ArrayList<Integer> currentArrowHashes = new ArrayList<Integer>();
        ArrayList nearbyEntities = new ArrayList();
        try {
            SpatialResource entitySpatialResource = (SpatialResource)commandBuffer.getResource(EntityModule.get().getEntitySpatialResourceType());
            entitySpatialResource.getSpatialStructure().collect(playerPos, 12.0, nearbyEntities);
            for (Ref entityRef : nearbyEntities) {
                Projectile projectile;
                if (entityRef.equals(playerRef) || (projectile = (Projectile)commandBuffer.getComponent(entityRef, Projectile.getComponentType())) == null) continue;
                int arrowHash = entityRef.hashCode();
                currentArrowHashes.add(arrowHash);
                TransformComponent entityTransform = (TransformComponent)commandBuffer.getComponent(entityRef, TransformComponent.getComponentType());
                if (entityTransform == null) continue;
                Vector3d arrowPos = entityTransform.getPosition();
                Velocity velocity = (Velocity)commandBuffer.getComponent(entityRef, Velocity.getComponentType());
                if (velocity == null) continue;
                Vector3d vel = velocity.getVelocity();
                double speed = Math.sqrt(vel.x * vel.x + vel.y * vel.y + vel.z * vel.z);
                ArrowTracker tracker = this.trackedArrows.get(arrowHash);
                if (tracker == null) {
                    tracker = new ArrowTracker(arrowPos, speed, this.currentTick);
                    this.trackedArrows.put(arrowHash, tracker);
                } else {
                    tracker.update(arrowPos, speed);
                }
                int aliveTicks = this.currentTick - tracker.spawnTick;
                if (aliveTicks < 5) continue;
                boolean shouldCollect = false;
                if (speed < 0.05) {
                    shouldCollect = true;
                }
                if (!shouldCollect) continue;
                double playerFeetY = playerPos.y;
                double minX = playerPos.x - 3.0;
                double maxX = playerPos.x + 3.0;
                double minY = playerFeetY - 1.5;
                double maxY = playerFeetY + eyeHeight + 3.0;
                double minZ = playerPos.z - 3.0;
                double maxZ = playerPos.z + 3.0;
                boolean insideBox = arrowPos.x >= minX && arrowPos.x <= maxX && arrowPos.y >= minY && arrowPos.y <= maxY && arrowPos.z >= minZ && arrowPos.z <= maxZ;
                if (!insideBox) continue;
                String arrowType = lastArrowEquipped.getOrDefault(playerUUID, "Weapon_Arrow_Crude");
                arrowsToCollect.add(new ArrowToCollect((Ref<EntityStore>)entityRef, arrowType));
            }
        }
        catch (Exception entitySpatialResource) {
            // empty catch block
        }
        this.trackedArrows.keySet().removeIf(hash -> !currentArrowHashes.contains(hash));
        if (!arrowsToCollect.isEmpty()) {
            int collected = 0;
            Inventory inventory = player.getInventory();
            for (ArrowToCollect arrowToCollect : arrowsToCollect) {
                try {
                    String arrowId;
                    ItemStack arrowStack;
                    ItemStack remainder;
                    if (inventory == null || (remainder = this.addItemToInventory(inventory, arrowStack = new ItemStack(arrowId = arrowToCollect.arrowType, 1))) != null && !remainder.isEmpty()) continue;
                    commandBuffer.tryRemoveEntity(arrowToCollect.ref, RemoveReason.REMOVE);
                    ++collected;
                    this.trackedArrows.remove(arrowToCollect.ref.hashCode());
                }
                catch (Exception exception) {}
            }
            if (collected > 0) {
                try {
                    SoundUtil.playSoundEvent2dToPlayer((PlayerRef)playerRefComponent, (int)SoundEvent.getAssetMap().getIndex((Object)"SFX_Player_Pickup_Item"), (SoundCategory)SoundCategory.SFX, (float)1.0f, (float)1.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.lastMessageTick.containsKey(playerUUID) || this.currentTick - this.lastMessageTick.get(playerUUID) > 20) {
                    this.lastMessageTick.put(playerUUID, this.currentTick);
                    player.sendInventory();
                }
            }
        }
    }

    private void detectBowAndArrow(@Nonnull Player player, @Nonnull UUID playerUUID) {
        try {
            String arrowId;
            ItemStack utilityArrow;
            String itemId;
            Inventory inventory = player.getInventory();
            if (inventory == null) {
                return;
            }
            ItemStack mainHandItem = inventory.getItemInHand();
            if (mainHandItem != null && !mainHandItem.isEmpty() && this.isBow(itemId = mainHandItem.getItemId()) && (utilityArrow = inventory.getUtility().getItemStack((short)0)) != null && !utilityArrow.isEmpty() && this.isArrow(utilityArrow.getItemId()) && !(arrowId = utilityArrow.getItemId()).equals(lastArrowEquipped.get(playerUUID))) {
                lastArrowEquipped.put(playerUUID, arrowId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isBow(@Nonnull String itemId) {
        return itemId.equals("Weapon_Bow_Basic") || itemId.equals("Weapon_Bow_Recurve") || itemId.equals("Weapon_Bow_Compound") || itemId.contains("Bow");
    }

    private boolean isArrow(@Nonnull String itemId) {
        return itemId.equals("Weapon_Arrow_Clearshot") || itemId.equals("Weapon_Arrow_Crude") || itemId.equals("Weapon_Arrow_Deadeye") || itemId.equals("Weapon_Arrow_Iron") || itemId.equals("Weapon_Arrow_Trueshot");
    }

    @Nullable
    private ItemStack addItemToInventory(@Nonnull Inventory inventory, @Nonnull ItemStack itemStack) {
        ItemStackTransaction transaction = inventory.getCombinedHotbarFirst().addItemStack(itemStack);
        return transaction.getRemainder();
    }

    public boolean isParallel(int archetypeChunkSize, int taskCount) {
        return EntityTickingSystem.maybeUseParallel((int)archetypeChunkSize, (int)taskCount);
    }

    @Nonnull
    public Query<EntityStore> getQuery() {
        return this.query;
    }

    private static class ArrowTracker {
        Vector3d lastPosition;
        double lastSpeed;
        boolean wasPreviouslyMoving;
        int spawnTick;

        ArrowTracker(Vector3d pos, double speed, int tick) {
            this.lastPosition = pos.clone();
            this.lastSpeed = speed;
            this.wasPreviouslyMoving = speed >= 0.05;
            this.spawnTick = tick;
        }

        void update(Vector3d pos, double speed) {
            this.wasPreviouslyMoving = this.lastSpeed >= 0.05;
            this.lastPosition = pos.clone();
            this.lastSpeed = speed;
        }
    }

    private static class ArrowToCollect {
        Ref<EntityStore> ref;
        String arrowType;

        ArrowToCollect(Ref<EntityStore> ref, String arrowType) {
            this.ref = ref;
            this.arrowType = arrowType;
        }
    }
}

