/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.itemmagnet;

import com.blamejared.itemmagnet.ItemMagnet;
import com.blamejared.itemmagnet.ItemMagnetConfig;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.spatial.SpatialResource;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.entity.EntityUtils;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.ModelComponent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.item.ItemComponent;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class MagnetSystem
extends EntityTickingSystem<EntityStore> {
    @Nonnull
    private final Query<EntityStore> query = Query.and((Query[])new Query[]{Player.getComponentType()});

    private boolean hasMagnet(Inventory inventory) {
        if (inventory != null) {
            if (inventory.getActiveHotbarItem() != null && inventory.getActiveHotbarItem().getItemId().equals("BlameJared_ItemMagnet_ItemMagnet")) {
                return true;
            }
            return inventory.getUtilityItem() != null && inventory.getUtilityItem().getItemId().equals("BlameJared_ItemMagnet_ItemMagnet");
        }
        return false;
    }

    public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        Ref playerRef = archetypeChunk.getReferenceTo(index);
        Player player = (Player)EntityUtils.toHolder((int)index, archetypeChunk).getComponent(Player.getComponentType());
        if (player != null && this.hasMagnet(player.getInventory())) {
            TransformComponent playerTransform = (TransformComponent)commandBuffer.getComponent(playerRef, TransformComponent.getComponentType());
            ModelComponent modelcomponent = (ModelComponent)commandBuffer.getComponent(playerRef, ModelComponent.getComponentType());
            if (playerTransform == null || modelcomponent == null) {
                return;
            }
            Vector3d playerPos = playerTransform.getPosition().clone().add(0.0, (double)modelcomponent.getModel().getEyeHeight(), 0.0);
            ArrayList nearby = new ArrayList();
            SpatialResource itemSpatialResource = (SpatialResource)commandBuffer.getResource(EntityModule.get().getItemSpatialResourceType());
            itemSpatialResource.getSpatialStructure().collect(playerPos, ((ItemMagnetConfig)ItemMagnet.INSTANCE.config.get()).pickupRadius(), nearby);
            for (Ref entityStoreRef : nearby) {
                TransformComponent entityPos = (TransformComponent)commandBuffer.getComponent(entityStoreRef, TransformComponent.getComponentType());
                ItemComponent pickup = (ItemComponent)commandBuffer.getComponent(entityStoreRef, ItemComponent.getComponentType());
                if (entityPos == null || pickup == null || !pickup.canPickUp()) continue;
                entityPos.getPosition().assign(Vector3d.lerp((Vector3d)entityPos.getPosition(), (Vector3d)playerPos, (double)((ItemMagnetConfig)ItemMagnet.INSTANCE.config.get()).moveSpeed()));
            }
        }
    }

    public boolean isParallel(int archetypeChunkSize, int taskCount) {
        return EntityTickingSystem.maybeUseParallel((int)archetypeChunkSize, (int)taskCount);
    }

    @Nonnull
    public Query<EntityStore> getQuery() {
        return this.query;
    }
}

