/*
 * Decompiled with CFR 0.152.
 */
package fr.samiracle.wtkeeper;

import com.hypixel.hytale.builtin.crafting.state.BenchState;
import com.hypixel.hytale.component.AddReason;
import com.hypixel.hytale.component.Archetype;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.ecs.BreakBlockEvent;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.modules.entity.item.ItemComponent;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import fr.samiracle.wtkeeper.WorkbenchTierUtils;
import fr.samiracle.wtkeeper.WorkbenchUpgradeChunk;
import javax.annotation.Nonnull;

public class WorkbenchUpgradeBreakBlockSystem
extends EntityEventSystem<EntityStore, BreakBlockEvent> {
    private final ComponentType<ChunkStore, WorkbenchUpgradeChunk> componentType;
    private final String metaKey;

    public WorkbenchUpgradeBreakBlockSystem(ComponentType<ChunkStore, WorkbenchUpgradeChunk> componentType, String metaKey) {
        super(BreakBlockEvent.class);
        this.componentType = componentType;
        this.metaKey = metaKey;
    }

    public void handle(int index, @Nonnull ArchetypeChunk<EntityStore> chunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer, @Nonnull BreakBlockEvent event) {
        BenchState benchState;
        Vector3i pos;
        if (event.isCancelled()) {
            return;
        }
        BlockType blockType = event.getBlockType();
        if (blockType.getBench() == null) {
            return;
        }
        EntityStore entityStore = (EntityStore)commandBuffer.getExternalData();
        World world = entityStore.getWorld();
        int tier = this.resolveTier(world, pos = event.getTargetBlock(), benchState = WorkbenchTierUtils.getBenchState(world, pos));
        if (tier <= 0) {
            return;
        }
        Ref entityRef = chunk.getReferenceTo(index);
        if (this.isCreativePlayer(commandBuffer, (Ref<EntityStore>)entityRef)) {
            this.removeTierFromCache(world, pos);
            return;
        }
        ItemStack drop = WorkbenchTierUtils.createWorkbenchItem(blockType, benchState, tier, this.metaKey, false);
        if (drop == null || drop.isEmpty()) {
            this.removeTierFromCache(world, pos);
            return;
        }
        Holder<EntityStore> dropHolder = this.createDropHolder(commandBuffer, (Ref<EntityStore>)entityRef, drop, pos);
        if (dropHolder == null) {
            this.removeTierFromCache(world, pos);
            return;
        }
        commandBuffer.addEntity(dropHolder, AddReason.SPAWN);
        this.dropContainerContents(commandBuffer, (Ref<EntityStore>)entityRef, world, pos);
        this.removeTierFromCache(world, pos);
        event.setCancelled(true);
        WorkbenchTierUtils.clearUpgradeItems(benchState);
        world.setBlock(pos.x, pos.y, pos.z, BlockType.EMPTY.getId(), 2048);
    }

    public Query<EntityStore> getQuery() {
        return Archetype.empty();
    }

    private int resolveTier(World world, Vector3i pos, BenchState benchState) {
        int tier;
        if (benchState != null && (tier = benchState.getTierLevel()) > 0) {
            return tier;
        }
        WorkbenchUpgradeChunk data = WorkbenchTierUtils.getChunkData(world, pos, this.componentType);
        if (data == null) {
            return 0;
        }
        Integer tier2 = data.getTier(pos);
        return tier2 == null ? 0 : tier2;
    }

    private void removeTierFromCache(World world, Vector3i pos) {
        WorkbenchUpgradeChunk data = WorkbenchTierUtils.getChunkData(world, pos, this.componentType);
        if (data != null) {
            data.removeTier(pos);
        }
    }

    private void dropContainerContents(CommandBuffer<EntityStore> commandBuffer, Ref<EntityStore> entityRef, World world, Vector3i pos) {
        ItemContainer container = WorkbenchTierUtils.getItemContainer(world, pos);
        if (container == null || container.isEmpty()) {
            return;
        }
        for (ItemStack stack : container.removeAllItemStacks()) {
            Holder<EntityStore> dropHolder;
            if (stack == null || stack.isEmpty() || (dropHolder = this.createDropHolder(commandBuffer, entityRef, stack, pos)) == null) continue;
            commandBuffer.addEntity(dropHolder, AddReason.SPAWN);
        }
    }

    private boolean isCreativePlayer(CommandBuffer<EntityStore> commandBuffer, Ref<EntityStore> entityRef) {
        if (entityRef == null) {
            return false;
        }
        Player player = (Player)commandBuffer.getComponent(entityRef, Player.getComponentType());
        if (player == null) {
            return false;
        }
        return player.getGameMode() == GameMode.Creative;
    }

    private Holder<EntityStore> createDropHolder(CommandBuffer<EntityStore> commandBuffer, Ref<EntityStore> entityRef, ItemStack itemStack, Vector3i blockPos) {
        Vector3d position = this.resolveDropPosition(commandBuffer, entityRef, blockPos);
        return ItemComponent.generateItemDrop(commandBuffer, (ItemStack)itemStack, (Vector3d)position, (Vector3f)Vector3f.ZERO, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    private Vector3d resolveDropPosition(CommandBuffer<EntityStore> commandBuffer, Ref<EntityStore> entityRef, Vector3i blockPos) {
        return new Vector3d((double)blockPos.x + 0.5, (double)blockPos.y + 0.5, (double)blockPos.z + 0.5);
    }
}

