/*
 * Decompiled with CFR 0.152.
 */
package fr.samiracle.wtkeeper;

import com.hypixel.hytale.server.core.entity.LivingEntity;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.entity.LivingEntityInventoryChangeEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import fr.samiracle.wtkeeper.WorkbenchTierItemNormalizer;

public class WorkbenchTierPlayerInventoryListener {
    private final WorkbenchTierItemNormalizer normalizer;

    public WorkbenchTierPlayerInventoryListener(String metaKey) {
        this.normalizer = new WorkbenchTierItemNormalizer(metaKey);
    }

    public void onPlayerReady(PlayerReadyEvent event) {
        Player player = event.getPlayer();
        Inventory inventory = player.getInventory();
        if (inventory == null) {
            return;
        }
        boolean changed = this.normalizeInventory(inventory);
        if (changed) {
            inventory.markChanged();
        }
    }

    public void onInventoryChange(LivingEntityInventoryChangeEvent event) {
        Inventory inventory;
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemContainer container = event.getItemContainer();
        if (container == null) {
            return;
        }
        boolean changed = this.normalizer.normalizeContainer(container);
        if (changed && (inventory = player.getInventory()) != null) {
            inventory.markChanged();
        }
    }

    private boolean normalizeInventory(Inventory inventory) {
        ItemContainer[] containers;
        boolean changed = false;
        for (ItemContainer container : containers = new ItemContainer[]{inventory.getHotbar(), inventory.getStorage(), inventory.getArmor(), inventory.getUtility(), inventory.getTools(), inventory.getBackpack()}) {
            changed |= this.normalizer.normalizeContainer(container);
        }
        return changed;
    }
}

