/*
 * Decompiled with CFR 0.152.
 */
package fr.samiracle.wtkeeper;

import com.hypixel.hytale.component.ComponentRegistryProxy;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.server.core.event.events.entity.LivingEntityInventoryChangeEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.Interaction;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import fr.samiracle.wtkeeper.WorkbenchPickInteraction;
import fr.samiracle.wtkeeper.WorkbenchTierChunkContainerScanSystem;
import fr.samiracle.wtkeeper.WorkbenchTierPlayerInventoryListener;
import fr.samiracle.wtkeeper.WorkbenchUpgradeBreakBlockSystem;
import fr.samiracle.wtkeeper.WorkbenchUpgradeChunk;
import fr.samiracle.wtkeeper.WorkbenchUpgradeEnsureChunkSystem;
import fr.samiracle.wtkeeper.WorkbenchUpgradePlaceBlockSystem;
import javax.annotation.Nonnull;

public class WorkbenchTierKeeper
extends JavaPlugin {
    public static final String META_TIER_KEY = "wtkeeper:tier";
    private ComponentType<ChunkStore, WorkbenchUpgradeChunk> workbenchUpgradeChunkType;

    public WorkbenchTierKeeper(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        super.setup();
        ComponentRegistryProxy chunkRegistry = this.getChunkStoreRegistry();
        ComponentRegistryProxy entityRegistry = this.getEntityStoreRegistry();
        this.workbenchUpgradeChunkType = chunkRegistry.registerComponent(WorkbenchUpgradeChunk.class, "WorkbenchUpgradeChunk", WorkbenchUpgradeChunk.CODEC);
        chunkRegistry.registerSystem((ISystem)new WorkbenchUpgradeEnsureChunkSystem(this.workbenchUpgradeChunkType));
        Interaction.CODEC.register("WorkbenchPick", WorkbenchPickInteraction.class, WorkbenchPickInteraction.CODEC);
        entityRegistry.registerSystem((ISystem)new WorkbenchUpgradePlaceBlockSystem(this.workbenchUpgradeChunkType, META_TIER_KEY));
        entityRegistry.registerSystem((ISystem)new WorkbenchUpgradeBreakBlockSystem(this.workbenchUpgradeChunkType, META_TIER_KEY));
        chunkRegistry.registerSystem((ISystem)new WorkbenchTierChunkContainerScanSystem(this.workbenchUpgradeChunkType, META_TIER_KEY));
        WorkbenchTierPlayerInventoryListener inventoryListener = new WorkbenchTierPlayerInventoryListener(META_TIER_KEY);
        this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, inventoryListener::onPlayerReady);
        this.getEventRegistry().registerGlobal(LivingEntityInventoryChangeEvent.class, inventoryListener::onInventoryChange);
    }
}

