/*
 * Decompiled with CFR 0.152.
 */
package fr.samiracle.wtkeeper;

import com.hypixel.hytale.component.AddReason;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.RemoveReason;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.HolderSystem;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerBlockState;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import fr.samiracle.wtkeeper.WorkbenchTierItemNormalizer;
import fr.samiracle.wtkeeper.WorkbenchUpgradeChunk;
import javax.annotation.Nonnull;

public class WorkbenchTierChunkContainerScanSystem
extends HolderSystem<ChunkStore> {
    private final ComponentType<ChunkStore, WorkbenchUpgradeChunk> componentType;
    private final WorkbenchTierItemNormalizer normalizer;

    public WorkbenchTierChunkContainerScanSystem(ComponentType<ChunkStore, WorkbenchUpgradeChunk> componentType, String metaKey) {
        this.componentType = componentType;
        this.normalizer = new WorkbenchTierItemNormalizer(metaKey);
    }

    public Query<ChunkStore> getQuery() {
        return WorldChunk.getComponentType();
    }

    public void onEntityAdd(@Nonnull Holder<ChunkStore> holder, @Nonnull AddReason reason, @Nonnull Store<ChunkStore> store) {
        holder.ensureComponent(this.componentType);
        WorldChunk chunk = (WorldChunk)holder.getComponent(WorldChunk.getComponentType());
        if (chunk == null) {
            return;
        }
        int minY = 0;
        int maxY = minY + 320;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    BlockState state = chunk.getState(x, y, z);
                    if (!(state instanceof ItemContainerBlockState)) continue;
                    ItemContainer container = ((ItemContainerBlockState)state).getItemContainer();
                    this.normalizer.normalizeContainer(container);
                }
            }
        }
    }

    public void onEntityRemoved(@Nonnull Holder<ChunkStore> holder, @Nonnull RemoveReason reason, @Nonnull Store<ChunkStore> store) {
    }
}

