/*
 * Decompiled with CFR 0.152.
 */
package fr.samiracle.wtkeeper;

import com.hypixel.hytale.builtin.crafting.state.BenchState;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.BlockPosition;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.modules.interaction.interaction.CooldownHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.SimpleInstantInteraction;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import fr.samiracle.wtkeeper.WorkbenchTierUtils;
import javax.annotation.Nonnull;

public class WorkbenchPickInteraction
extends SimpleInstantInteraction {
    public static final BuilderCodec<WorkbenchPickInteraction> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(WorkbenchPickInteraction.class, WorkbenchPickInteraction::new, (BuilderCodec)SimpleInstantInteraction.CODEC).documentation("Pick a workbench and keep its tier metadata.")).build();

    protected void firstRun(@Nonnull InteractionType interactionType, @Nonnull InteractionContext context, @Nonnull CooldownHandler cooldownHandler) {
        ItemStack stack;
        int level;
        Vector3i pos;
        if (interactionType != InteractionType.Pick) {
            return;
        }
        CommandBuffer commandBuffer = context.getCommandBuffer();
        if (commandBuffer == null) {
            return;
        }
        Ref entityRef = context.getEntity();
        Player player = (Player)commandBuffer.getComponent(entityRef, Player.getComponentType());
        if (player == null || player.getGameMode() != GameMode.Creative) {
            return;
        }
        BlockPosition targetBlock = context.getTargetBlock();
        if (targetBlock == null) {
            return;
        }
        EntityStore entityStore = (EntityStore)commandBuffer.getExternalData();
        World world = entityStore.getWorld();
        BlockType blockType = world.getBlockType(pos = new Vector3i(targetBlock.x, targetBlock.y, targetBlock.z));
        if (blockType == null || blockType.getBench() == null) {
            return;
        }
        BenchState benchState = WorkbenchTierUtils.getBenchState(world, pos);
        int tier = 1;
        if (benchState != null && (level = benchState.getTierLevel()) > 0) {
            tier = level;
        }
        if ((stack = WorkbenchTierUtils.createWorkbenchItem(blockType, benchState, tier, "wtkeeper:tier", true)) == null || stack.isEmpty()) {
            return;
        }
        Inventory inventory = player.getInventory();
        if (inventory == null) {
            return;
        }
        byte slot = inventory.getActiveHotbarSlot();
        if (slot == -1) {
            return;
        }
        ItemContainer hotbar = inventory.getHotbar();
        if (hotbar == null) {
            return;
        }
        hotbar.setItemStackForSlot((short)slot, stack);
        inventory.markChanged();
    }
}

